/*
 * Decompiled with CFR 0.152.
 */
package io.kokuwa.maven.helm;

import io.kokuwa.maven.helm.AbstractHelmWithValueOverrideMojo;
import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="install", defaultPhase=LifecyclePhase.DEPLOY)
public class InstallMojo
extends AbstractHelmWithValueOverrideMojo {
    @Parameter(property="action", defaultValue="install")
    private String action;
    @Parameter(property="helm.install.skip", defaultValue="true")
    private boolean skipInstall;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip || this.skipInstall) {
            this.getLog().info((CharSequence)"Skip install");
            return;
        }
        for (String inputDirectory : this.getChartDirectories(this.getChartDirectory())) {
            this.getLog().info((CharSequence)String.format("\n\nPerform install for chart %s...", inputDirectory));
            String clusterName = new File(inputDirectory).getName();
            this.callCli(String.format("%s %s %s %s %s %s %s %s", this.getHelmExecuteablePath(), this.action, clusterName, inputDirectory, this.formatIfValueIsNotEmpty("--registry-config=%s", this.getRegistryConfig()), this.formatIfValueIsNotEmpty("--repository-cache=%s", this.getRepositoryCache()), this.formatIfValueIsNotEmpty("--repository-config=%s", this.getRepositoryConfig()), this.getValuesOptions()), "Failed to deploy helm chart");
        }
    }

    public InstallMojo setAction(String action) {
        this.action = action;
        return this;
    }

    public InstallMojo setSkipInstall(boolean skipInstall) {
        this.skipInstall = skipInstall;
        return this;
    }
}

