/*
 * Decompiled with CFR 0.152.
 */
package io.kokuwa.maven.helm;

import io.kokuwa.maven.helm.AbstractHelmWithValueOverrideMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="lint", defaultPhase=LifecyclePhase.TEST)
public class LintMojo
extends AbstractHelmWithValueOverrideMojo {
    @Parameter(property="helm.lint.skip", defaultValue="false")
    private boolean skipLint;
    @Parameter(property="helm.lint.strict", defaultValue="false")
    private boolean lintStrict;

    public void execute() throws MojoExecutionException {
        if (this.skip || this.skipLint) {
            this.getLog().info((CharSequence)"Skip lint");
            return;
        }
        for (String inputDirectory : this.getChartDirectories(this.getChartDirectory())) {
            this.getLog().info((CharSequence)("\n\nTesting chart " + inputDirectory + "..."));
            this.callCli(this.getHelmExecuteablePath() + " lint " + inputDirectory + (this.lintStrict ? " --strict" : "") + (StringUtils.isNotEmpty((String)this.getRegistryConfig()) ? " --registry-config=" + this.getRegistryConfig() : "") + (StringUtils.isNotEmpty((String)this.getRepositoryCache()) ? " --repository-cache=" + this.getRepositoryCache() : "") + (StringUtils.isNotEmpty((String)this.getRepositoryConfig()) ? " --repository-config=" + this.getRepositoryConfig() : "") + this.getValuesOptions(), "There are test failures");
        }
    }

    public LintMojo setSkipLint(boolean skipLint) {
        this.skipLint = skipLint;
        return this;
    }

    public LintMojo setLintStrict(boolean lintStrict) {
        this.lintStrict = lintStrict;
        return this;
    }
}

