/*
 * Decompiled with CFR 0.152.
 */
package io.kokuwa.maven.helm;

import io.kokuwa.maven.helm.AbstractHelmMojo;
import io.kokuwa.maven.helm.pojo.HelmRepository;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.compress.utils.FileNameUtils;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="push", defaultPhase=LifecyclePhase.DEPLOY)
public class PushMojo
extends AbstractHelmMojo {
    private static final String LOGIN_COMMAND_TEMPLATE = " registry login -u %s %s --password-stdin ";
    private static final String CHART_PUSH_TEMPLATE = " push %s oci://%s ";
    @Parameter(property="helm.push.skip", defaultValue="false")
    private boolean skipPush;

    public void execute() throws MojoExecutionException {
        ComparableVersion minimumHelmVersion;
        if (this.skip || this.skipPush) {
            this.getLog().info((CharSequence)"Skip push");
            return;
        }
        HelmRepository registry = this.getHelmUploadRepo();
        if (Objects.isNull(registry)) {
            this.getLog().info((CharSequence)"there is no helm repo. skipping the upload.");
            return;
        }
        ComparableVersion helmVersion = new ComparableVersion(this.getHelmVersion());
        if (helmVersion.compareTo(minimumHelmVersion = new ComparableVersion("3.8.0")) < 0) {
            this.getLog().error((CharSequence)("your helm version is " + helmVersion.toString() + ", it's required to be >=3.8.0"));
            throw new IllegalStateException();
        }
        this.getLog().debug((CharSequence)("helm version minimum satisfied. the version is: " + helmVersion.toString()));
        if (registry.getUsername() != null && registry.getPassword() != null) {
            this.callCli(this.getHelmExecuteablePath() + String.format(LOGIN_COMMAND_TEMPLATE, registry.getUsername(), registry.getUrl()), "can't login to registry", registry.getPassword());
        }
        this.getLog().info((CharSequence)("Uploading to " + registry.getUrl()));
        this.getChartTgzs(this.getOutputDirectory()).forEach(chartTgzFile -> {
            this.getLog().info((CharSequence)("Uploading " + chartTgzFile));
            try {
                this.uploadSingle(Paths.get(chartTgzFile, new String[0]), registry);
            }
            catch (MojoExecutionException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void uploadSingle(Path tgz, HelmRepository registry) throws MojoExecutionException {
        this.callCli(this.getHelmExecuteablePath() + String.format(CHART_PUSH_TEMPLATE, tgz, registry.getUrl()), "");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    List<String> getChartTgzs(String path) throws MojoExecutionException {
        try (Stream<Path> files = Files.walk(Paths.get(path, new String[0]), new FileVisitOption[0]);){
            List<String> list = files.filter(p -> FileNameUtils.getExtension((String)p.toFile().getName()).equals("tgz")).map(Path::toString).collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to scan repo directory at " + path, (Exception)e);
        }
    }

    public PushMojo setSkipPush(boolean skipPush) {
        this.skipPush = skipPush;
        return this;
    }
}

