/*
 * Decompiled with CFR 0.152.
 */
package io.kokuwa.maven.helm;

import io.kokuwa.maven.helm.AbstractHelmMojo;
import io.kokuwa.maven.helm.pojo.HelmExecutable;
import java.nio.file.Path;
import java.time.Clock;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="package", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true)
public class PackageMojo
extends AbstractHelmMojo {
    @Parameter(property="helm.package.skip", defaultValue="false")
    private boolean skipPackage;
    @Parameter(property="helm.package.keyring")
    private String keyring;
    @Parameter(property="helm.package.key")
    private String key;
    @Parameter(property="helm.package.passphrase")
    private String passphrase;
    @Parameter(property="helm.appVersion")
    private String appVersion;
    @Parameter(property="helm.chartVersion.timestampOnSnapshot", defaultValue="false")
    private boolean timestampOnSnapshot;
    @Parameter(property="helm.chartVersion.timestampFormat", defaultValue="yyyyMMddHHmmss")
    private String timestampFormat;

    public void execute() throws MojoExecutionException {
        if (this.skip || this.skipPackage) {
            this.getLog().info((CharSequence)"Skip package");
            return;
        }
        String chartVersion = this.getChartVersion();
        if (chartVersion != null) {
            if (this.timestampOnSnapshot && chartVersion.endsWith("-SNAPSHOT")) {
                String suffix = DateTimeFormatter.ofPattern(this.timestampFormat).format(this.getTimestamp());
                chartVersion = chartVersion.replace("SNAPSHOT", suffix);
            }
            this.getLog().info((CharSequence)("Setting chart version to " + chartVersion));
        }
        for (Path chartDirectory : this.getChartDirectories()) {
            this.getLog().info((CharSequence)("Packaging chart " + chartDirectory + "..."));
            HelmExecutable helm = this.helm().arguments("package", chartDirectory).flag("destination", this.getOutputDirectory()).flag("version", chartVersion).flag("app-version", this.appVersion);
            if (StringUtils.isNotEmpty((String)this.keyring) && StringUtils.isNotEmpty((String)this.key)) {
                this.getLog().info((CharSequence)"Enable signing");
                helm.flag("sign").flag("keyring", this.keyring).flag("key", this.key);
                if (StringUtils.isNotEmpty((String)this.passphrase)) {
                    helm.flag("passphrase-file", "-").setStdin(this.passphrase);
                }
            }
            helm.execute("Unable to package chart at " + chartDirectory);
        }
    }

    LocalDateTime getTimestamp() {
        return LocalDateTime.now(Clock.systemDefaultZone());
    }

    public PackageMojo setSkipPackage(boolean skipPackage) {
        this.skipPackage = skipPackage;
        return this;
    }

    public PackageMojo setKeyring(String keyring) {
        this.keyring = keyring;
        return this;
    }

    public PackageMojo setKey(String key) {
        this.key = key;
        return this;
    }

    public PackageMojo setPassphrase(String passphrase) {
        this.passphrase = passphrase;
        return this;
    }

    public PackageMojo setAppVersion(String appVersion) {
        this.appVersion = appVersion;
        return this;
    }

    public PackageMojo setTimestampOnSnapshot(boolean timestampOnSnapshot) {
        this.timestampOnSnapshot = timestampOnSnapshot;
        return this;
    }

    public PackageMojo setTimestampFormat(String timestampFormat) {
        this.timestampFormat = timestampFormat;
        return this;
    }
}

