/*
 * Decompiled with CFR 0.152.
 */
package io.kokuwa.maven.helm;

import io.kokuwa.maven.helm.AbstractHelmWithValueOverrideMojo;
import java.nio.file.Path;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="upgrade", defaultPhase=LifecyclePhase.DEPLOY, threadSafe=true)
public class UpgradeMojo
extends AbstractHelmWithValueOverrideMojo {
    @Parameter(property="helm.upgrade.skip", defaultValue="true")
    private boolean skipUpgrade;
    @Parameter(property="helm.upgrade.atomic")
    private boolean upgradeAtomic;
    @Parameter(property="helm.upgrade.timeout")
    private Integer upgradeTimeout;
    @Parameter(property="helm.upgrade.upgradeWithInstall", defaultValue="true")
    private boolean upgradeWithInstall;
    @Parameter(property="helm.upgrade.dryRun", defaultValue="false")
    private boolean upgradeDryRun;
    @Parameter(property="helm.releaseName")
    private String releaseName;

    public void execute() throws MojoExecutionException {
        if (this.skip || this.skipUpgrade) {
            this.getLog().info((CharSequence)"Skip upgrade");
            return;
        }
        for (Path chartDirectory : this.getChartDirectories()) {
            this.getLog().info((CharSequence)("Upgrading the chart " + (this.upgradeWithInstall ? "with install " : "") + (this.upgradeAtomic ? "with atomic " : "") + (this.upgradeTimeout != null ? this.upgradeTimeout + "s" : "") + (this.upgradeDryRun ? "as dry run " : "") + chartDirectory));
            this.helm().arguments("upgrade", this.releaseName, chartDirectory).flag("install", this.upgradeWithInstall).flag("dry-run", this.upgradeDryRun).flag("atomic", this.upgradeAtomic).flag("timeout", this.upgradeTimeout != null ? this.upgradeTimeout + "s" : null).execute("Error occurred while upgrading the chart");
        }
    }

    public UpgradeMojo setSkipUpgrade(boolean skipUpgrade) {
        this.skipUpgrade = skipUpgrade;
        return this;
    }

    public UpgradeMojo setUpgradeAtomic(boolean upgradeAtomic) {
        this.upgradeAtomic = upgradeAtomic;
        return this;
    }

    public UpgradeMojo setUpgradeTimeout(Integer upgradeTimeout) {
        this.upgradeTimeout = upgradeTimeout;
        return this;
    }

    public UpgradeMojo setUpgradeWithInstall(boolean upgradeWithInstall) {
        this.upgradeWithInstall = upgradeWithInstall;
        return this;
    }

    public UpgradeMojo setUpgradeDryRun(boolean upgradeDryRun) {
        this.upgradeDryRun = upgradeDryRun;
        return this;
    }

    public UpgradeMojo setReleaseName(String releaseName) {
        this.releaseName = releaseName;
        return this;
    }
}

