/*
 * Decompiled with CFR 0.152.
 */
package io.kokuwa.maven.helm;

import io.kokuwa.maven.helm.AbstractHelmMojo;
import io.kokuwa.maven.helm.util.DependencyOverwriter;
import java.nio.file.Path;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="dependency-build", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, threadSafe=true)
public class DependencyBuildMojo
extends AbstractHelmMojo {
    @Parameter(property="helm.dependency-build.skip", defaultValue="false")
    private boolean skipDependencyBuild;
    @Parameter(property="helm.overwriteLocalDependencies", defaultValue="false")
    private boolean overwriteLocalDependencies;
    @Parameter(property="helm.overwriteDependencyVersion")
    private String overwriteDependencyVersion;
    @Parameter(property="helm.overwriteDependencyRepository")
    private String overwriteDependencyRepository;

    public void execute() throws MojoExecutionException {
        if (this.skip || this.skipDependencyBuild) {
            this.getLog().info((CharSequence)"Skip dependency build");
            return;
        }
        for (Path chartDirectory : this.getChartDirectories()) {
            if (this.overwriteLocalDependencies) {
                if (this.overwriteDependencyRepository == null) {
                    throw new MojoExecutionException("Null value for 'overwriteDependencyRepository' is not allowed when using 'overwriteLocalDependencies'. See the README for more details.");
                }
                this.getLog().info((CharSequence)("Overwriting dependencies that contain local path charts with " + this.overwriteDependencyRepository));
                new DependencyOverwriter(this.overwriteDependencyRepository, this.overwriteDependencyVersion, this.getLog()).execute(chartDirectory);
            }
            this.getLog().info((CharSequence)("Build chart dependencies for " + chartDirectory + " ..."));
            this.helm().arguments("dependency", "build", chartDirectory).execute("Failed to resolve dependencies");
        }
    }

    public DependencyBuildMojo setSkipDependencyBuild(boolean skipDependencyBuild) {
        this.skipDependencyBuild = skipDependencyBuild;
        return this;
    }

    public DependencyBuildMojo setOverwriteLocalDependencies(boolean overwriteLocalDependencies) {
        this.overwriteLocalDependencies = overwriteLocalDependencies;
        return this;
    }

    public DependencyBuildMojo setOverwriteDependencyVersion(String overwriteDependencyVersion) {
        this.overwriteDependencyVersion = overwriteDependencyVersion;
        return this;
    }

    public DependencyBuildMojo setOverwriteDependencyRepository(String overwriteDependencyRepository) {
        this.overwriteDependencyRepository = overwriteDependencyRepository;
        return this;
    }
}

