/*
 * Decompiled with CFR 0.152.
 */
package io.kokuwa.maven.helm;

import io.kokuwa.maven.helm.AbstractHelmWithValueOverrideMojo;
import java.nio.file.Path;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="install", defaultPhase=LifecyclePhase.DEPLOY, threadSafe=true)
public class InstallMojo
extends AbstractHelmWithValueOverrideMojo {
    @Deprecated
    @Parameter(property="action", defaultValue="install")
    private String action;
    @Parameter(property="helm.install.atomic")
    private boolean installAtomic;
    @Parameter(property="helm.install.timeout")
    private Integer installTimeout;
    @Parameter(property="helm.install.force")
    private boolean installForce;
    @Parameter(property="helm.install.skip", defaultValue="true")
    private boolean skipInstall;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip || this.skipInstall) {
            this.getLog().info((CharSequence)"Skip install");
            return;
        }
        for (Path chartDirectory : this.getChartDirectories()) {
            this.getLog().info((CharSequence)(String.format("\n\nPerform install for chart %s...", chartDirectory) + (this.installAtomic ? " with atomic" : "") + (this.installTimeout != null ? this.installTimeout + "s" : "")));
            this.helm().arguments(this.action, chartDirectory.getFileName().toString(), chartDirectory).flag("atomic", this.installAtomic).flag("force", this.installForce).flag("timeout", this.installTimeout != null ? this.installTimeout + "s" : null).execute("Failed to deploy helm chart");
        }
    }

    @Deprecated
    public InstallMojo setAction(String action) {
        this.action = action;
        return this;
    }

    public InstallMojo setInstallAtomic(boolean installAtomic) {
        this.installAtomic = installAtomic;
        return this;
    }

    public InstallMojo setInstallTimeout(Integer installTimeout) {
        this.installTimeout = installTimeout;
        return this;
    }

    public InstallMojo setInstallForce(boolean installForce) {
        this.installForce = installForce;
        return this;
    }

    public InstallMojo setSkipInstall(boolean skipInstall) {
        this.skipInstall = skipInstall;
        return this;
    }
}

