/*
 * Decompiled with CFR 0.152.
 */
package io.kokuwa.maven.helm;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DatabindException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.kokuwa.maven.helm.AbstractHelmMojo;
import io.kokuwa.maven.helm.TLSHelper;
import io.kokuwa.maven.helm.pojo.Catalog;
import io.kokuwa.maven.helm.pojo.HelmRepository;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="upload", defaultPhase=LifecyclePhase.DEPLOY, threadSafe=true)
public class UploadMojo
extends AbstractHelmMojo {
    private static final ObjectMapper MAPPER = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
    private static final String CATALOG_ARTIFACT_NAME = "helm-catalog";
    private static final String CATALOG_ARTIFACT_TYPE = "json";
    @Parameter(property="helm.upload.skip", defaultValue="false")
    private boolean skipUpload;
    @Parameter(defaultValue="${project.groupId}", readonly=true)
    private String projectGroupId;
    @Parameter(defaultValue="${project.artifactId}", readonly=true)
    private String projectArtifactId;
    @Parameter(defaultValue="${project.version}", readonly=true)
    private String projectVersion;
    @Parameter(property="helm.upload.insecure", defaultValue="false")
    private boolean insecure;
    @Parameter(property="helm.upload.skip.catalog", defaultValue="true")
    private boolean skipCatalog;

    public void execute() throws MojoExecutionException {
        if (this.skip || this.skipUpload) {
            this.getLog().info((CharSequence)"Skip upload");
            return;
        }
        this.getLog().info((CharSequence)("Uploading to " + this.getHelmUploadUrl() + "\n"));
        for (Path chart : this.getChartArchives()) {
            this.getLog().info((CharSequence)("Uploading " + chart + "..."));
            try {
                this.uploadSingle(chart);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Upload failed.", (Exception)e);
            }
        }
        if (!this.skipCatalog) {
            Path catalogPath = this.getCatalogFilePath();
            this.getLog().info((CharSequence)("Attaching catalog artifact: " + catalogPath));
            this.mavenProjectHelper.attachArtifact(this.mavenProject, CATALOG_ARTIFACT_TYPE, CATALOG_ARTIFACT_NAME, catalogPath.toFile());
        }
    }

    private String getHelmUploadUrl() {
        String chartVersion = this.getChartVersion();
        HelmRepository uploadRepoStable = this.getUploadRepoStable();
        HelmRepository uploadRepoSnapshot = this.getUploadRepoSnapshot();
        String uploadUrl = uploadRepoStable.getUrl();
        if (chartVersion != null && chartVersion.endsWith("-SNAPSHOT") && uploadRepoSnapshot != null && StringUtils.isNotEmpty((String)uploadRepoSnapshot.getUrl())) {
            uploadUrl = uploadRepoSnapshot.getUrl();
        }
        return uploadUrl;
    }

    List<Catalog> readCatalog(File catalogFile) throws MojoExecutionException {
        ArrayList<Catalog> catalogList = new ArrayList<Catalog>();
        if (catalogFile == null || !catalogFile.exists()) {
            return catalogList;
        }
        try {
            return Arrays.asList((Object[])MAPPER.readValue(catalogFile, Catalog[].class));
        }
        catch (DatabindException e) {
            this.getLog().warn((CharSequence)"Unable to parse the existing catalog file content. Overwriting data.");
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failure occurred while reading the catalog file.", (Exception)e);
        }
        return catalogList;
    }

    private String createCatalogContent(Catalog data) throws MojoExecutionException {
        File file = this.getCatalogFilePath().toFile();
        List<Catalog> catalog = this.readCatalog(file);
        catalog.add(data);
        try {
            return MAPPER.writeValueAsString(catalog);
        }
        catch (JsonProcessingException e) {
            throw new MojoExecutionException("Failure occurred while writing the catalog content as a JSON string.", (Exception)((Object)e));
        }
    }

    protected Path getCatalogFilePath() {
        String catalogFileName = String.format("%s.%s", CATALOG_ARTIFACT_NAME, CATALOG_ARTIFACT_TYPE);
        return Paths.get(this.mavenProject.getBuild().getDirectory(), catalogFileName);
    }

    private void catalogHelmChart(String content) throws MojoExecutionException {
        Path catalogPath = this.getCatalogFilePath();
        File catalogFile = catalogPath.toFile();
        this.getLog().debug((CharSequence)("Writing content to catalog file: " + content));
        try (OutputStream out = Files.newOutputStream(catalogFile.toPath(), new OpenOption[0]);){
            OutputStreamWriter fileWriter = new OutputStreamWriter(out, StandardCharsets.UTF_8);
            fileWriter.write(content);
            fileWriter.close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failure occurred while writing the catalog file.", (Exception)e);
        }
    }

    private void uploadSingle(Path chart) throws MojoExecutionException, IOException {
        HttpURLConnection connection;
        File fileToUpload = chart.toFile();
        HelmRepository uploadRepo = this.getHelmUploadRepo();
        if (uploadRepo.getType() == null) {
            throw new IllegalArgumentException("Repository type missing. Check your plugin configuration.");
        }
        switch (uploadRepo.getType()) {
            case ARTIFACTORY: {
                connection = this.getConnectionForUploadToArtifactory(fileToUpload, uploadRepo);
                break;
            }
            case CHARTMUSEUM: {
                connection = this.getConnectionForUploadToChartMuseum();
                break;
            }
            case NEXUS: {
                connection = this.getConnectionForUploadToNexus(fileToUpload);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported repository type for upload.");
            }
        }
        if (this.insecure && connection instanceof HttpsURLConnection) {
            this.getLog().info((CharSequence)("Use insecure TLS connection for [" + connection.getURL() + "]"));
            TLSHelper.insecure((HttpsURLConnection)connection);
        }
        try (FileInputStream fileInputStream = new FileInputStream(fileToUpload);){
            IOUtils.copy((InputStream)fileInputStream, (OutputStream)connection.getOutputStream());
        }
        if (connection.getResponseCode() >= 300) {
            String response = connection.getErrorStream() != null ? new String(IOUtils.toByteArray((InputStream)connection.getErrorStream()), StandardCharsets.UTF_8) : (connection.getInputStream() != null ? new String(IOUtils.toByteArray((InputStream)connection.getInputStream()), StandardCharsets.UTF_8) : "No details provided");
            throw new MojoExecutionException("Failed to upload: " + response);
        }
        String message = "Returned: " + connection.getResponseCode();
        String details = "";
        if (connection.getInputStream() != null && !(details = new String(IOUtils.toByteArray((InputStream)connection.getInputStream()), StandardCharsets.UTF_8)).isEmpty()) {
            message = message + " - " + details;
        }
        this.getLog().info((CharSequence)message);
        if (!this.skipCatalog) {
            Catalog data = new Catalog(chart, connection.getURL(), connection.getContentType(), details);
            this.catalogHelmChart(this.createCatalogContent(data));
        }
        connection.disconnect();
    }

    private HttpURLConnection getConnectionForUploadToChartMuseum() throws IOException, MojoExecutionException {
        HttpURLConnection connection = (HttpURLConnection)new URL(this.getHelmUploadUrl()).openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/gzip");
        this.setBasicAuthHeader(connection);
        return connection;
    }

    private void setBasicAuthHeader(HttpURLConnection connection) throws MojoExecutionException {
        PasswordAuthentication authentication = this.getAuthentication(this.getHelmUploadRepo());
        if (authentication != null) {
            String encoded = Base64.getEncoder().encodeToString((authentication.getUserName() + ":" + new String(authentication.getPassword())).getBytes(StandardCharsets.UTF_8));
            connection.setRequestProperty("Authorization", "Basic " + encoded);
        }
    }

    private HttpURLConnection getConnectionForUploadToArtifactory(File file, HelmRepository repo) throws IOException, MojoExecutionException {
        String uploadUrl = this.getHelmUploadUrl();
        if (!uploadUrl.endsWith("/")) {
            uploadUrl = uploadUrl + "/";
        }
        if (repo.isUseGroupId()) {
            uploadUrl = uploadUrl + this.projectGroupId.replace(".", "/") + "/";
        }
        if (repo.isUseArtifactId()) {
            uploadUrl = uploadUrl + this.projectArtifactId.replace(".", "/") + "/";
        }
        if (repo.isUseGroupId() || repo.isUseArtifactId()) {
            uploadUrl = uploadUrl + this.projectVersion + "/";
        }
        uploadUrl = uploadUrl + file.getName();
        HttpURLConnection connection = (HttpURLConnection)new URL(uploadUrl).openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("PUT");
        connection.setRequestProperty("Content-Type", "application/gzip");
        this.verifyAndSetAuthentication(true);
        return connection;
    }

    private HttpURLConnection getConnectionForUploadToNexus(File file) throws IOException, MojoExecutionException {
        String uploadUrl = this.getHelmUploadUrl();
        if (!uploadUrl.endsWith("/")) {
            uploadUrl = uploadUrl + "/";
        }
        uploadUrl = uploadUrl + file.getName();
        HttpURLConnection connection = (HttpURLConnection)new URL(uploadUrl).openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("PUT");
        connection.setRequestProperty("Content-Type", "application/gzip");
        this.verifyAndSetAuthentication(false);
        return connection;
    }

    private void verifyAndSetAuthentication(boolean requireCredentials) throws MojoExecutionException {
        final PasswordAuthentication authentication = this.getAuthentication(this.getHelmUploadRepo());
        if (authentication != null) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return authentication;
                }
            });
        } else if (requireCredentials) {
            throw new IllegalArgumentException("Credentials has to be configured for uploading to Artifactory.");
        }
    }

    public UploadMojo setSkipUpload(boolean skipUpload) {
        this.skipUpload = skipUpload;
        return this;
    }

    public UploadMojo setProjectGroupId(String projectGroupId) {
        this.projectGroupId = projectGroupId;
        return this;
    }

    public UploadMojo setProjectArtifactId(String projectArtifactId) {
        this.projectArtifactId = projectArtifactId;
        return this;
    }

    public UploadMojo setProjectVersion(String projectVersion) {
        this.projectVersion = projectVersion;
        return this;
    }

    public UploadMojo setInsecure(boolean insecure) {
        this.insecure = insecure;
        return this;
    }

    public UploadMojo setSkipCatalog(boolean skipCatalog) {
        this.skipCatalog = skipCatalog;
        return this;
    }
}

