/*
 * Decompiled with CFR 0.152.
 */
package io.kokuwa.maven.helm;

import io.kokuwa.maven.helm.AbstractDependencyMojo;
import java.nio.file.Path;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="dependency-build", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, threadSafe=true)
public class DependencyBuildMojo
extends AbstractDependencyMojo {
    @Parameter(property="helm.dependency-build.skip", defaultValue="false")
    private boolean skipDependencyBuild;

    public void execute() throws MojoExecutionException {
        if (this.skip || this.skipDependencyBuild) {
            this.getLog().info((CharSequence)"Skip dependency build");
            return;
        }
        for (Path chartDirectory : this.getChartDirectories()) {
            this.doOverwriteLocalDependencies(chartDirectory);
            this.getLog().info((CharSequence)("Build chart dependencies for " + chartDirectory + " ..."));
            this.helm().arguments("dependency", "build", chartDirectory).execute("Failed to resolve dependencies");
        }
    }

    public DependencyBuildMojo setSkipDependencyBuild(boolean skipDependencyBuild) {
        this.skipDependencyBuild = skipDependencyBuild;
        return this;
    }
}

