/*
 * Decompiled with CFR 0.152.
 */
package io.kokuwa.maven.helm;

import io.kokuwa.maven.helm.AbstractDependencyMojo;
import java.nio.file.Path;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="dependency-update", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, threadSafe=true)
public class DependencyUpdateMojo
extends AbstractDependencyMojo {
    @Parameter(property="helm.dependency-update.skip", defaultValue="false")
    private boolean skipDependencyUpdate;

    public void execute() throws MojoExecutionException {
        if (this.skip || this.skipDependencyUpdate) {
            this.getLog().info((CharSequence)"Skip dependency update");
            return;
        }
        for (Path chartDirectory : this.getChartDirectories()) {
            this.doOverwriteLocalDependencies(chartDirectory);
            this.getLog().info((CharSequence)("Updating chart dependencies for " + chartDirectory + " ..."));
            this.helm().arguments("dependency", "update", chartDirectory).execute("Failed to resolve dependencies");
        }
    }

    public DependencyUpdateMojo setSkipDependencyUpdate(boolean skipDependencyUpdate) {
        this.skipDependencyUpdate = skipDependencyUpdate;
        return this;
    }
}

