/*
 * Decompiled with CFR 0.152.
 */
package io.kokuwa.maven.helm;

import io.kokuwa.maven.helm.AbstractHelmMojo;
import io.kokuwa.maven.helm.util.DependencyOverwriter;
import java.nio.file.Path;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractDependencyMojo
extends AbstractHelmMojo {
    @Parameter(property="helm.overwriteLocalDependencies", defaultValue="false")
    protected boolean overwriteLocalDependencies;
    @Parameter(property="helm.overwriteDependencyVersion")
    protected String overwriteDependencyVersion;
    @Parameter(property="helm.overwriteDependencyRepository")
    protected String overwriteDependencyRepository;

    protected void doOverwriteLocalDependencies(Path chartDirectory) throws MojoExecutionException {
        if (this.overwriteLocalDependencies) {
            if (this.overwriteDependencyRepository == null) {
                throw new MojoExecutionException("Null value for 'overwriteDependencyRepository' is not allowed when using 'overwriteLocalDependencies'. See the README for more details.");
            }
            this.getLog().info((CharSequence)("Overwriting dependencies that contain local path charts with " + this.overwriteDependencyRepository));
            new DependencyOverwriter(this.overwriteDependencyRepository, this.overwriteDependencyVersion, this.getLog()).execute(chartDirectory);
        }
    }

    public AbstractDependencyMojo setOverwriteLocalDependencies(boolean overwriteLocalDependencies) {
        this.overwriteLocalDependencies = overwriteLocalDependencies;
        return this;
    }

    public AbstractDependencyMojo setOverwriteDependencyVersion(String overwriteDependencyVersion) {
        this.overwriteDependencyVersion = overwriteDependencyVersion;
        return this;
    }

    public AbstractDependencyMojo setOverwriteDependencyRepository(String overwriteDependencyRepository) {
        this.overwriteDependencyRepository = overwriteDependencyRepository;
        return this;
    }
}

