/*
 * Decompiled with CFR 0.152.
 */
package io.kokuwa.maven.helm;

import io.kokuwa.maven.helm.AbstractHelmWithValueOverrideMojo;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractHandleMojo
extends AbstractHelmWithValueOverrideMojo {
    @Parameter(property="helm.releaseName")
    private String releaseName;

    List<Chart> getCharts() throws MojoExecutionException {
        List<Path> chartDirectories = this.getChartDirectories();
        if (this.releaseName != null && chartDirectories.size() > 1) {
            throw new MojoExecutionException("For multiple charts releaseName is not supported.");
        }
        return chartDirectories.stream().map(p -> new Chart(this.releaseName == null ? p.getFileName().toString() : this.releaseName, (Path)p)).collect(Collectors.toList());
    }

    public AbstractHandleMojo setReleaseName(String releaseName) {
        this.releaseName = releaseName;
        return this;
    }

    final class Chart {
        private final String releaseName;
        private final Path directory;

        public Chart(String releaseName, Path directory) {
            this.releaseName = releaseName;
            this.directory = directory;
        }

        public String getReleaseName() {
            return this.releaseName;
        }

        public Path getDirectory() {
            return this.directory;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Chart)) {
                return false;
            }
            Chart other = (Chart)o;
            String this$releaseName = this.getReleaseName();
            String other$releaseName = other.getReleaseName();
            if (this$releaseName == null ? other$releaseName != null : !this$releaseName.equals(other$releaseName)) {
                return false;
            }
            Path this$directory = this.getDirectory();
            Path other$directory = other.getDirectory();
            return !(this$directory == null ? other$directory != null : !((Object)this$directory).equals(other$directory));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $releaseName = this.getReleaseName();
            result = result * 59 + ($releaseName == null ? 43 : $releaseName.hashCode());
            Path $directory = this.getDirectory();
            result = result * 59 + ($directory == null ? 43 : ((Object)$directory).hashCode());
            return result;
        }

        public String toString() {
            return "AbstractHandleMojo.Chart(releaseName=" + this.getReleaseName() + ", directory=" + this.getDirectory() + ")";
        }
    }
}

