/*
 * Decompiled with CFR 0.152.
 */
package io.kokuwa.maven.helm;

import io.kokuwa.maven.helm.AbstractDependencyMojo;
import io.kokuwa.maven.helm.pojo.HelmExecutable;
import java.nio.file.Path;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="dependency-build", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, threadSafe=true)
public class DependencyBuildMojo
extends AbstractDependencyMojo {
    @Parameter(property="helm.dependency-build.skip", defaultValue="false")
    private boolean skipDependencyBuild;
    @Parameter(property="helm.dependency-build.skip-repo-refresh", defaultValue="false")
    private boolean skipDependencyBuildRepoRefresh;

    public void execute() throws MojoExecutionException {
        if (this.skip || this.skipDependencyBuild) {
            this.getLog().info((CharSequence)"Skip dependency build");
            return;
        }
        for (Path chartDirectory : this.getChartDirectories()) {
            this.doOverwriteLocalDependencies(chartDirectory);
            this.getLog().info((CharSequence)("Build chart dependencies for " + chartDirectory + " ..."));
            HelmExecutable helm = this.helm().arguments("dependency", "build", chartDirectory);
            if (this.skipDependencyBuildRepoRefresh) {
                helm.flag("skip-refresh");
            }
            helm.execute("Failed to resolve dependencies");
        }
    }

    public DependencyBuildMojo setSkipDependencyBuild(boolean skipDependencyBuild) {
        this.skipDependencyBuild = skipDependencyBuild;
        return this;
    }

    public DependencyBuildMojo setSkipDependencyBuildRepoRefresh(boolean skipDependencyBuildRepoRefresh) {
        this.skipDependencyBuildRepoRefresh = skipDependencyBuildRepoRefresh;
        return this;
    }
}

