/*
 * Decompiled with CFR 0.152.
 */
package io.kokuwa.maven.helm;

import io.kokuwa.maven.helm.AbstractHelmMojo;
import io.kokuwa.maven.helm.TLSHelper;
import io.kokuwa.maven.helm.pojo.HelmExecutable;
import io.kokuwa.maven.helm.pojo.HelmRepository;
import java.io.BufferedInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclEntryType;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Server;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="init", defaultPhase=LifecyclePhase.INITIALIZE, threadSafe=true)
public class InitMojo
extends AbstractHelmMojo {
    public static final String STABLE_HELM_REPO = "https://charts.helm.sh/stable";
    @Parameter(property="helm.init.skip", defaultValue="false")
    private boolean skipInit;
    @Parameter(property="helm.init.add-default-repo", defaultValue="true")
    private boolean addDefaultRepo;
    @Parameter(property="helm.init.add-upload-repos", defaultValue="false")
    private boolean addUploadRepos;
    @Parameter
    private HelmRepository[] helmExtraRepos;
    @Parameter(property="helm.repo.add.force-update", defaultValue="false")
    private boolean repositoryAddForceUpdate;
    @Parameter(property="helm.repo.add.pass-credentials", defaultValue="false")
    private boolean repositoryAddPassCredentials;
    @Parameter(property="helm.downloadUrl")
    private URL helmDownloadUrl;
    @Parameter(property="helm.downloadUser")
    private String helmDownloadUser;
    @Parameter(property="helm.downloadPassword")
    private String helmDownloadPassword;
    @Parameter(property="helm.downloadServerId")
    private String helmDownloadServerId;
    @Parameter(property="helm.init.fallbackBinaryDownload", defaultValue="false")
    private boolean fallbackBinaryDownload;

    public void execute() throws MojoExecutionException {
        if (this.skip || this.skipInit) {
            this.getLog().info((CharSequence)"Skip init");
            return;
        }
        this.getLog().info((CharSequence)"Initializing Helm...");
        Path outputDirectory = this.getOutputDirectory();
        if (!outputDirectory.toFile().exists()) {
            this.getLog().info((CharSequence)"Creating output directory...");
            try {
                Files.createDirectories(outputDirectory, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to create output directory at " + outputDirectory, (Exception)e);
            }
        }
        if (this.isUseLocalHelmBinary()) {
            try {
                this.helm().arguments("version").execute("Unable to verify local HELM binary");
                this.getLog().info((CharSequence)("Using local HELM binary [" + this.getHelmExecutablePath() + "]"));
            }
            catch (MojoExecutionException e) {
                if (this.fallbackBinaryDownload) {
                    this.getLog().info((CharSequence)"Local HELM binary not found => falling back to binary download");
                    this.downloadAndUnpackHelm();
                }
                this.getLog().error((CharSequence)"Local HELM binary not found.");
                throw e;
            }
        } else {
            this.downloadAndUnpackHelm();
        }
        if (this.addDefaultRepo) {
            HelmRepository stableHelmRepo = new HelmRepository();
            stableHelmRepo.setName("stable");
            stableHelmRepo.setUrl(STABLE_HELM_REPO);
            this.addRepository(stableHelmRepo, false);
        }
        if (this.addUploadRepos) {
            if (this.getUploadRepoStable() != null) {
                this.addRepository(this.getUploadRepoStable(), true);
            }
            if (!(this.getUploadRepoSnapshot() == null || this.getUploadRepoStable() != null && this.getUploadRepoStable().getName().equals(this.getUploadRepoSnapshot().getName()))) {
                this.addRepository(this.getUploadRepoSnapshot(), true);
            }
        }
        if (this.helmExtraRepos != null) {
            for (HelmRepository repository : this.helmExtraRepos) {
                this.addRepository(repository, true);
            }
        }
    }

    private void addRepository(HelmRepository repository, boolean authenticationRequired) throws MojoExecutionException {
        PasswordAuthentication auth;
        this.getLog().info((CharSequence)("Adding repo [" + repository + "]"));
        HelmExecutable helm = this.helm().arguments("repo", "add", repository.getName(), repository.getUrl()).flag("force-update", this.repositoryAddForceUpdate || repository.isForceUpdate()).flag("pass-credentials", this.repositoryAddPassCredentials || repository.isPassCredentials());
        PasswordAuthentication passwordAuthentication = auth = authenticationRequired ? this.getAuthentication(repository) : null;
        if (auth != null) {
            helm.flag("username", auth.getUserName()).flag("password", String.valueOf(auth.getPassword()));
        }
        helm.execute("Unable add repo");
    }

    private void downloadAndUnpackHelm() throws MojoExecutionException {
        Path directory = this.getHelmExecutableDirectory();
        if (Files.exists(directory.resolve(this.getHelmExecutableName()), new LinkOption[0])) {
            this.getLog().info((CharSequence)"Found helm executable, skip init.");
            return;
        }
        URL url = this.helmDownloadUrl == null ? new URL(String.format("https://get.helm.sh/helm-v%s-%s-%s.%s", this.getHelmVersion(), this.getOperatingSystem(), this.getArchitecture(), this.getExtension())) : this.helmDownloadUrl;
        this.getLog().debug((CharSequence)("Downloading Helm: " + url));
        boolean found = false;
        final Server downloadServer = this.getSettings().getServer(this.helmDownloadServerId);
        if (StringUtils.isNotBlank((String)this.helmDownloadUser) && StringUtils.isNotBlank((String)this.helmDownloadPassword) && downloadServer != null) {
            throw new MojoExecutionException("Either use only helm.downloadUser and helm.downloadPassword or helm.downloadServerId properties");
        }
        if (StringUtils.isNotBlank((String)this.helmDownloadUser) && StringUtils.isNotBlank((String)this.helmDownloadPassword)) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(InitMojo.this.helmDownloadUser, InitMojo.this.helmDownloadPassword.toCharArray());
                }
            });
        }
        if (downloadServer != null) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(downloadServer.getUsername(), downloadServer.getPassword().toCharArray());
                }
            });
        }
        try (InputStream dis = this.openConnection(url).getInputStream();
             InputStream cis = this.createCompressorInputStream(dis);
             ArchiveInputStream<?> is = this.createArchiverInputStream(cis);){
            Files.createDirectories(directory, new FileAttribute[0]);
            ArchiveEntry entry = null;
            while (!found && (entry = is.getNextEntry()) != null) {
                String name = entry.getName();
                if (entry.isDirectory() || !name.endsWith("helm.exe") && !name.endsWith("helm")) {
                    this.getLog().debug((CharSequence)("Skip archive entry with name: " + name));
                    continue;
                }
                this.getLog().debug((CharSequence)("Use archive entry with name: " + name));
                Path helm = directory.resolve(name.endsWith(".exe") ? "helm.exe" : "helm");
                try (FileOutputStream output = new FileOutputStream(helm.toFile());){
                    IOUtils.copy(is, (OutputStream)output);
                }
                this.addExecPermission(helm);
                found = true;
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to download and extract helm executable.", (Exception)e);
        }
        if (!found) {
            throw new MojoExecutionException("Unable to find helm executable in tar file.");
        }
    }

    private URLConnection openConnection(URL url) throws IOException, MojoExecutionException {
        URLConnection connection;
        Proxy proxy = this.settings.getProxies().stream().filter(p -> {
            if (!p.isActive()) return false;
            if (!Stream.of(Optional.ofNullable(p.getNonProxyHosts()).orElse("").split("\\|")).noneMatch(url.getHost()::equals)) return false;
            return true;
        }).findFirst().map(p -> {
            this.getLog().debug((CharSequence)("Use proxy [" + p.getId() + "] for [" + url + "]"));
            return new Proxy(Optional.ofNullable(p.getProtocol()).map(String::toUpperCase).map(Proxy.Type::valueOf).orElse(Proxy.Type.HTTP), new InetSocketAddress(p.getHost(), p.getPort()));
        }).orElse(null);
        if (proxy == null) {
            connection = url.openConnection();
        } else {
            connection = url.openConnection(proxy);
            if (connection instanceof HttpsURLConnection) {
                TLSHelper.insecure((HttpsURLConnection)connection);
            }
        }
        return connection;
    }

    private void addExecPermission(Path helm) throws IOException {
        Set<String> fileAttributeView = FileSystems.getDefault().supportedFileAttributeViews();
        if (fileAttributeView.contains("posix")) {
            Set<PosixFilePermission> permissions;
            try {
                permissions = Files.getPosixFilePermissions(helm, new LinkOption[0]);
            }
            catch (UnsupportedOperationException e) {
                this.getLog().debug((CharSequence)"Exec file permission is not set", (Throwable)e);
                return;
            }
            permissions.add(PosixFilePermission.OWNER_EXECUTE);
            Files.setPosixFilePermissions(helm, permissions);
        } else if (fileAttributeView.contains("acl")) {
            String username = System.getProperty("user.name");
            UserPrincipal userPrincipal = FileSystems.getDefault().getUserPrincipalLookupService().lookupPrincipalByName(username);
            AclEntry aclEntry = AclEntry.newBuilder().setPermissions(AclEntryPermission.EXECUTE).setType(AclEntryType.ALLOW).setPrincipal(userPrincipal).build();
            AclFileAttributeView acl = Files.getFileAttributeView(helm, AclFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
            List<AclEntry> aclEntries = acl.getAcl();
            aclEntries.add(aclEntry);
            acl.setAcl(aclEntries);
        }
    }

    private ArchiveInputStream<?> createArchiverInputStream(InputStream is) throws MojoExecutionException {
        InputStream inputStream = is.markSupported() ? is : new BufferedInputStream(is);
        try {
            return new ArchiveStreamFactory().createArchiveInputStream(inputStream);
        }
        catch (ArchiveException e) {
            throw new MojoExecutionException("Unsupported archive type downloaded", (Exception)((Object)e));
        }
    }

    private InputStream createCompressorInputStream(InputStream is) throws MojoExecutionException {
        InputStream inputStream = is.markSupported() ? is : new BufferedInputStream(is);
        String compressorType = null;
        try {
            compressorType = CompressorStreamFactory.detect((InputStream)inputStream);
        }
        catch (CompressorException e) {
            this.getLog().debug((CharSequence)"Unknown type of compressed stream", (Throwable)e);
        }
        if (compressorType != null) {
            try {
                return new CompressorStreamFactory().createCompressorInputStream(compressorType, inputStream);
            }
            catch (CompressorException e) {
                throw new MojoExecutionException("Unsupported compressor type: " + compressorType);
            }
        }
        return inputStream;
    }

    private String getArchitecture() {
        String architecture = System.getProperty("os.arch").toLowerCase(Locale.US);
        if (architecture.equals("x86_64") || architecture.equals("amd64")) {
            return "amd64";
        }
        if (architecture.equals("x86") || architecture.equals("i386")) {
            return "386";
        }
        if (architecture.contains("arm64") || architecture.equals("aarch64")) {
            return "arm64";
        }
        if (architecture.equals("aarch32") || architecture.startsWith("arm")) {
            return "arm";
        }
        if (architecture.contains("ppc64le") || architecture.contains("ppc64") && System.getProperty("sun.cpu.endian").equals("little")) {
            return "ppc64le";
        }
        throw new IllegalStateException("Unsupported architecture: " + architecture);
    }

    private String getExtension() {
        return Os.OS_FAMILY.equals("windows") ? "zip" : "tar.gz";
    }

    private String getOperatingSystem() {
        switch (Os.OS_FAMILY) {
            case "unix": {
                return "linux";
            }
            case "mac": {
                return "darwin";
            }
            case "windows": {
                return "windows";
            }
        }
        throw new IllegalStateException("Unsupported OS: " + Os.OS_FAMILY);
    }

    public InitMojo setSkipInit(boolean skipInit) {
        this.skipInit = skipInit;
        return this;
    }

    public InitMojo setAddDefaultRepo(boolean addDefaultRepo) {
        this.addDefaultRepo = addDefaultRepo;
        return this;
    }

    public InitMojo setAddUploadRepos(boolean addUploadRepos) {
        this.addUploadRepos = addUploadRepos;
        return this;
    }

    public InitMojo setHelmExtraRepos(HelmRepository[] helmExtraRepos) {
        this.helmExtraRepos = helmExtraRepos;
        return this;
    }

    public InitMojo setRepositoryAddForceUpdate(boolean repositoryAddForceUpdate) {
        this.repositoryAddForceUpdate = repositoryAddForceUpdate;
        return this;
    }

    public InitMojo setRepositoryAddPassCredentials(boolean repositoryAddPassCredentials) {
        this.repositoryAddPassCredentials = repositoryAddPassCredentials;
        return this;
    }

    public InitMojo setHelmDownloadUrl(URL helmDownloadUrl) {
        this.helmDownloadUrl = helmDownloadUrl;
        return this;
    }

    public InitMojo setHelmDownloadUser(String helmDownloadUser) {
        this.helmDownloadUser = helmDownloadUser;
        return this;
    }

    public InitMojo setHelmDownloadPassword(String helmDownloadPassword) {
        this.helmDownloadPassword = helmDownloadPassword;
        return this;
    }

    public InitMojo setHelmDownloadServerId(String helmDownloadServerId) {
        this.helmDownloadServerId = helmDownloadServerId;
        return this;
    }

    public InitMojo setFallbackBinaryDownload(boolean fallbackBinaryDownload) {
        this.fallbackBinaryDownload = fallbackBinaryDownload;
        return this;
    }
}

