/*
 * Decompiled with CFR 0.152.
 */
package io.kokuwa.maven.helm;

import io.kokuwa.maven.helm.AbstractHandleMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="install", defaultPhase=LifecyclePhase.DEPLOY, threadSafe=true)
public class InstallMojo
extends AbstractHandleMojo {
    @Deprecated
    @Parameter(property="action", defaultValue="install")
    private String action;
    @Parameter(property="helm.install.atomic")
    private boolean installAtomic;
    @Parameter(property="helm.install.timeout")
    private Integer installTimeout;
    @Parameter(property="helm.install.force")
    private boolean installForce;
    @Parameter(property="helm.install.plain-http")
    private Boolean installPlainHttp;
    @Parameter(property="helm.install.skip", defaultValue="true")
    private boolean skipInstall;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip || this.skipInstall) {
            this.getLog().info((CharSequence)"Skip install");
            return;
        }
        for (AbstractHandleMojo.Chart chart : this.getCharts()) {
            this.getLog().info((CharSequence)("Perform install for chart " + chart.getReleaseName() + " " + (this.installAtomic ? " with atomic" : "") + (this.installTimeout != null ? this.installTimeout + "s" : "") + chart.getDirectory()));
            this.helm().arguments(this.action, chart.getReleaseName(), chart.getDirectory()).flag("atomic", this.installAtomic).flag("force", this.installForce).flag("plain-http", this.isPlainHttp(this.installPlainHttp)).flag("timeout", this.installTimeout != null ? this.installTimeout + "s" : null).execute("Failed to deploy helm chart");
        }
    }

    @Deprecated
    public InstallMojo setAction(String action) {
        this.action = action;
        return this;
    }

    public InstallMojo setInstallAtomic(boolean installAtomic) {
        this.installAtomic = installAtomic;
        return this;
    }

    public InstallMojo setInstallTimeout(Integer installTimeout) {
        this.installTimeout = installTimeout;
        return this;
    }

    public InstallMojo setInstallForce(boolean installForce) {
        this.installForce = installForce;
        return this;
    }

    public InstallMojo setInstallPlainHttp(Boolean installPlainHttp) {
        this.installPlainHttp = installPlainHttp;
        return this;
    }

    public InstallMojo setSkipInstall(boolean skipInstall) {
        this.skipInstall = skipInstall;
        return this;
    }
}

