/*
 * Decompiled with CFR 0.152.
 */
package io.kokuwa.maven.helm;

import io.kokuwa.maven.helm.AbstractHandleMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="uninstall", defaultPhase=LifecyclePhase.DEPLOY, threadSafe=true)
public class UninstallMojo
extends AbstractHandleMojo {
    @Parameter(property="helm.uninstall.cascade")
    private String uninstallCascade;
    @Parameter(property="helm.uninstall.no-hooks", defaultValue="false")
    private boolean uninstallNoHooks;
    @Parameter(property="helm.uninstall.ignore-not-found ", defaultValue="false")
    private boolean uninstallIgnoreNotFound;
    @Parameter(property="helm.uninstall.keep-history ", defaultValue="false")
    private boolean uninstallKeepHistory;
    @Parameter(property="helm.uninstall.wait ", defaultValue="false")
    private boolean uninstallWait;
    @Parameter(property="helm.uninstall.timeout")
    private Integer uninstallTimeout;
    @Parameter(property="helm.uninstall.skip", defaultValue="true")
    private boolean skipUninstall;

    public void execute() throws MojoExecutionException {
        if (this.skip || this.skipUninstall) {
            this.getLog().info((CharSequence)"Skip uninstall");
            return;
        }
        for (AbstractHandleMojo.Chart charts : this.getCharts()) {
            this.getLog().info((CharSequence)("Perform uninstall for chart with name " + charts.getReleaseName()));
            this.helm().arguments("uninstall", charts.getReleaseName()).flag("wait", this.uninstallWait).flag("timeout", this.uninstallTimeout != null ? this.uninstallTimeout + "s" : null).flag("cascade", this.uninstallCascade).flag("no-hooks", this.uninstallNoHooks).flag("keep-history", this.uninstallKeepHistory).flag("ignore-not-found", this.uninstallIgnoreNotFound).execute("Failed to deploy helm chart");
        }
    }

    public UninstallMojo setUninstallCascade(String uninstallCascade) {
        this.uninstallCascade = uninstallCascade;
        return this;
    }

    public UninstallMojo setUninstallNoHooks(boolean uninstallNoHooks) {
        this.uninstallNoHooks = uninstallNoHooks;
        return this;
    }

    public UninstallMojo setUninstallIgnoreNotFound(boolean uninstallIgnoreNotFound) {
        this.uninstallIgnoreNotFound = uninstallIgnoreNotFound;
        return this;
    }

    public UninstallMojo setUninstallKeepHistory(boolean uninstallKeepHistory) {
        this.uninstallKeepHistory = uninstallKeepHistory;
        return this;
    }

    public UninstallMojo setUninstallWait(boolean uninstallWait) {
        this.uninstallWait = uninstallWait;
        return this;
    }

    public UninstallMojo setUninstallTimeout(Integer uninstallTimeout) {
        this.uninstallTimeout = uninstallTimeout;
        return this;
    }

    public UninstallMojo setSkipUninstall(boolean skipUninstall) {
        this.skipUninstall = skipUninstall;
        return this;
    }
}

