/*
 * Decompiled with CFR 0.152.
 */
package io.kokuwa.maven.helm;

import io.kokuwa.maven.helm.AbstractHelmMojo;
import io.kokuwa.maven.helm.pojo.HelmExecutable;
import io.kokuwa.maven.helm.pojo.ValueOverride;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractHelmWithValueOverrideMojo
extends AbstractHelmMojo {
    @Parameter
    private ValueOverride values;

    @Override
    HelmExecutable helm() throws MojoExecutionException {
        HelmExecutable command = super.helm();
        if (this.values != null) {
            if (AbstractHelmWithValueOverrideMojo.isNotEmpty(this.values.getOverrides())) {
                command.flag("set", this.values.getOverrides().entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(",")));
            }
            if (AbstractHelmWithValueOverrideMojo.isNotEmpty(this.values.getStringOverrides())) {
                command.flag("set-string", this.values.getStringOverrides().entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(",")));
            }
            if (AbstractHelmWithValueOverrideMojo.isNotEmpty(this.values.getFileOverrides())) {
                command.flag("set-file", this.values.getFileOverrides().entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(",")));
            }
            if (this.values.getYamlFile() != null) {
                command.flag("values", this.values.getYamlFile());
            }
            if (this.values.getYamlFiles() != null) {
                this.values.getYamlFiles().forEach(yamlFile -> command.flag("values", (String)yamlFile));
            }
        }
        return command;
    }

    private static <K, V> boolean isNotEmpty(Map<K, V> map) {
        return map != null && !map.isEmpty();
    }

    @Generated
    public AbstractHelmWithValueOverrideMojo setValues(ValueOverride values) {
        this.values = values;
        return this;
    }
}

