/*
 * Decompiled with CFR 0.152.
 */
package io.kokuwa.maven.helm;

import io.kokuwa.maven.helm.AbstractHelmWithValueOverrideMojo;
import java.nio.file.Path;
import lombok.Generated;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="lint", defaultPhase=LifecyclePhase.TEST, threadSafe=true)
public class LintMojo
extends AbstractHelmWithValueOverrideMojo {
    @Parameter(property="helm.lint.skip", defaultValue="false")
    private boolean skipLint;
    @Parameter(property="helm.lint.strict", defaultValue="false")
    private boolean lintStrict;
    @Parameter(property="helm.lint.quiet", defaultValue="false")
    private boolean lintQuiet;

    public void execute() throws MojoExecutionException {
        if (this.skip || this.skipLint) {
            this.getLog().info((CharSequence)"Skip lint");
            return;
        }
        for (Path chartDirectory : this.getChartDirectories()) {
            this.getLog().info((CharSequence)("\n\nTesting chart " + chartDirectory + "..."));
            this.helm().arguments("lint", chartDirectory).flag("strict", this.lintStrict).flag("quiet", this.lintQuiet).execute("There are linting issues");
        }
    }

    @Generated
    public LintMojo setSkipLint(boolean skipLint) {
        this.skipLint = skipLint;
        return this;
    }

    @Generated
    public LintMojo setLintStrict(boolean lintStrict) {
        this.lintStrict = lintStrict;
        return this;
    }

    @Generated
    public LintMojo setLintQuiet(boolean lintQuiet) {
        this.lintQuiet = lintQuiet;
        return this;
    }
}

