/*
 * Decompiled with CFR 0.152.
 */
package io.kokuwa.maven.helm;

import io.kokuwa.maven.helm.AbstractHelmMojo;
import io.kokuwa.maven.helm.pojo.HelmRepository;
import lombok.Generated;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="registry-logout", defaultPhase=LifecyclePhase.DEPLOY, threadSafe=true)
public class RegistryLogoutMojo
extends AbstractHelmMojo {
    @Parameter(property="helm.registry-logout.skip", defaultValue="false")
    private boolean skipRegistryLogout;

    public void execute() throws MojoExecutionException {
        if (this.skip || this.skipRegistryLogout) {
            this.getLog().info((CharSequence)"Skip registry logout");
            return;
        }
        HelmRepository repository = this.getHelmUploadRepo();
        if (repository == null) {
            this.getLog().warn((CharSequence)"No upload repo found for logout, skipped.");
            return;
        }
        this.helm().arguments("registry", "logout", repository.getUrl()).execute("Failed to logout from repository " + repository.getName() + " at " + repository.getUrl());
    }

    @Generated
    public RegistryLogoutMojo setSkipRegistryLogout(boolean skipRegistryLogout) {
        this.skipRegistryLogout = skipRegistryLogout;
        return this;
    }
}

