/*
 * Decompiled with CFR 0.152.
 */
package io.kokuwa.maven.helm;

import io.kokuwa.maven.helm.AbstractHelmWithValueOverrideMojo;
import java.io.File;
import java.nio.file.Path;
import lombok.Generated;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="template", defaultPhase=LifecyclePhase.TEST, threadSafe=true)
public class TemplateMojo
extends AbstractHelmWithValueOverrideMojo {
    @Deprecated
    @Parameter(property="action", defaultValue="template")
    private String action;
    @Parameter(property="helm.template.name-template")
    private String templateNameTemplate;
    @Parameter(property="helm.template.output-dir")
    private File templateOutputDir;
    @Parameter(property="helm.template.generate-name", defaultValue="false")
    private boolean templateGenerateName;
    @Deprecated
    @Parameter(property="helm.additional.arguments")
    private String additionalArguments;
    @Parameter(property="helm.template.plain-http")
    private Boolean templatePlainHttp;
    @Parameter(property="helm.template.skip", defaultValue="true")
    private boolean skipTemplate;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip || this.skipTemplate) {
            this.getLog().info((CharSequence)"Skip template");
            return;
        }
        for (Path chartDirectory : this.getChartDirectories()) {
            this.getLog().info((CharSequence)String.format("\n\nPerform template for chart %s...", chartDirectory));
            this.helm().arguments(this.action, chartDirectory).arguments(this.getArguments()).flag("output-dir", this.templateOutputDir).flag("name-template", this.templateNameTemplate).flag("generate-name", this.templateGenerateName).flag("plain-http", this.isPlainHttp(this.templatePlainHttp)).execute("There are test failures");
        }
    }

    private Object[] getArguments() {
        if (StringUtils.isEmpty((String)this.additionalArguments)) {
            return new Object[0];
        }
        this.getLog().warn((CharSequence)"NOTE: <additionalArguments> option will be removed in future major release.");
        return this.additionalArguments.split(" ");
    }

    @Deprecated
    @Generated
    public TemplateMojo setAction(String action) {
        this.action = action;
        return this;
    }

    @Generated
    public TemplateMojo setTemplateNameTemplate(String templateNameTemplate) {
        this.templateNameTemplate = templateNameTemplate;
        return this;
    }

    @Generated
    public TemplateMojo setTemplateOutputDir(File templateOutputDir) {
        this.templateOutputDir = templateOutputDir;
        return this;
    }

    @Generated
    public TemplateMojo setTemplateGenerateName(boolean templateGenerateName) {
        this.templateGenerateName = templateGenerateName;
        return this;
    }

    @Deprecated
    @Generated
    public TemplateMojo setAdditionalArguments(String additionalArguments) {
        this.additionalArguments = additionalArguments;
        return this;
    }

    @Generated
    public TemplateMojo setTemplatePlainHttp(Boolean templatePlainHttp) {
        this.templatePlainHttp = templatePlainHttp;
        return this;
    }

    @Generated
    public TemplateMojo setSkipTemplate(boolean skipTemplate) {
        this.skipTemplate = skipTemplate;
        return this;
    }
}

