/*
 * Decompiled with CFR 0.152.
 */
package io.kokuwa.maven.helm;

import io.kokuwa.maven.helm.AbstractHandleMojo;
import lombok.Generated;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="upgrade", defaultPhase=LifecyclePhase.DEPLOY, threadSafe=true)
public class UpgradeMojo
extends AbstractHandleMojo {
    @Parameter(property="helm.upgrade.skip", defaultValue="true")
    private boolean skipUpgrade;
    @Parameter(property="helm.upgrade.atomic")
    private boolean upgradeAtomic;
    @Parameter(property="helm.upgrade.timeout")
    private Integer upgradeTimeout;
    @Parameter(property="helm.upgrade.upgradeWithInstall", defaultValue="true")
    private boolean upgradeWithInstall;
    @Parameter(property="helm.upgrade.dryRun", defaultValue="false")
    private boolean upgradeDryRun;
    @Parameter(property="helm.upgrade.force")
    private boolean upgradeForce;
    @Parameter(property="helm.upgrade.plain-http")
    private Boolean upgradePlainHttp;

    public void execute() throws MojoExecutionException {
        if (this.skip || this.skipUpgrade) {
            this.getLog().info((CharSequence)"Skip upgrade");
            return;
        }
        for (AbstractHandleMojo.Chart chart : this.getCharts()) {
            this.getLog().info((CharSequence)("Upgrading the chart " + chart.getReleaseName() + " " + (this.upgradeWithInstall ? "with install " : "") + (this.upgradeAtomic ? "with atomic " : "") + (this.upgradeTimeout != null ? this.upgradeTimeout + "s" : "") + (this.upgradeDryRun ? "as dry run " : "") + chart.getDirectory()));
            this.helm().arguments("upgrade", chart.getReleaseName(), chart.getDirectory()).flag("install", this.upgradeWithInstall).flag("dry-run", this.upgradeDryRun).flag("atomic", this.upgradeAtomic).flag("force", this.upgradeForce).flag("plain-http", this.isPlainHttp(this.upgradePlainHttp)).flag("timeout", this.upgradeTimeout != null ? this.upgradeTimeout + "s" : null).execute("Error occurred while upgrading the chart");
        }
    }

    @Generated
    public UpgradeMojo setSkipUpgrade(boolean skipUpgrade) {
        this.skipUpgrade = skipUpgrade;
        return this;
    }

    @Generated
    public UpgradeMojo setUpgradeAtomic(boolean upgradeAtomic) {
        this.upgradeAtomic = upgradeAtomic;
        return this;
    }

    @Generated
    public UpgradeMojo setUpgradeTimeout(Integer upgradeTimeout) {
        this.upgradeTimeout = upgradeTimeout;
        return this;
    }

    @Generated
    public UpgradeMojo setUpgradeWithInstall(boolean upgradeWithInstall) {
        this.upgradeWithInstall = upgradeWithInstall;
        return this;
    }

    @Generated
    public UpgradeMojo setUpgradeDryRun(boolean upgradeDryRun) {
        this.upgradeDryRun = upgradeDryRun;
        return this;
    }

    @Generated
    public UpgradeMojo setUpgradeForce(boolean upgradeForce) {
        this.upgradeForce = upgradeForce;
        return this;
    }

    @Generated
    public UpgradeMojo setUpgradePlainHttp(Boolean upgradePlainHttp) {
        this.upgradePlainHttp = upgradePlainHttp;
        return this;
    }
}

