/*
 * Decompiled with CFR 0.152.
 */
package io.kokuwa.maven.helm.github;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.kokuwa.maven.helm.github.ReleaseCache;
import io.kokuwa.maven.helm.github.ReleaseResponse;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import lombok.Generated;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public class Github {
    private static final String LATEST_RELEASE_URL = "https://api.github.com/repos/helm/helm/releases/latest";
    private static final String RELEASE_FILE = "github-release.json";
    private final ObjectMapper mapper = new ObjectMapper();
    private final Log log;
    private final Path tmpDir;
    private final String userAgent;

    public String getHelmVersion() throws MojoExecutionException {
        String tagName = this.getReleaseResponse().getTagName();
        String version = tagName.startsWith("v") ? tagName.substring(1) : tagName;
        this.log.info((CharSequence)("Use " + version + " as helm version"));
        return version;
    }

    private ReleaseResponse getReleaseResponse() throws MojoExecutionException {
        Optional<ReleaseCache> cache = this.readCache();
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(LATEST_RELEASE_URL).openConnection();
            connection.setRequestProperty("User-Agent", this.userAgent);
            connection.setRequestProperty("Accept", "application/json");
            cache.map(ReleaseCache::getEtag).ifPresent(etag -> connection.setRequestProperty("If-None-Match", (String)etag));
            int responseCode = connection.getResponseCode();
            if (responseCode == 304) {
                this.log.debug((CharSequence)"Cache not modified");
                return cache.get().getResponse();
            }
            if (responseCode != 200) {
                throw new MojoExecutionException("Failed to get helm version from github api, response code was " + responseCode);
            }
            ReleaseResponse response = (ReleaseResponse)this.mapper.readValue(connection.getInputStream(), ReleaseResponse.class);
            this.log.debug((CharSequence)"Got valid response from github");
            this.writeCache(new ReleaseCache().setEtag(connection.getHeaderField("ETag")).setResponse(response));
            return response;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to get helm version", (Exception)e);
        }
    }

    private void writeCache(ReleaseCache cache) {
        Path file = this.tmpDir.resolve(RELEASE_FILE);
        try {
            Files.createDirectories(this.tmpDir, new FileAttribute[0]);
            this.mapper.writeValue(this.tmpDir.resolve(RELEASE_FILE).toFile(), (Object)cache);
            this.log.debug((CharSequence)("Wrote Github cache to " + file));
        }
        catch (IOException e) {
            this.log.warn((CharSequence)("Failed to write cache to " + file), (Throwable)e);
        }
    }

    private Optional<ReleaseCache> readCache() {
        Path file = this.tmpDir.resolve(RELEASE_FILE);
        if (!Files.exists(file, new LinkOption[0])) {
            this.log.debug((CharSequence)("Github cache not found at " + file));
            return Optional.empty();
        }
        try {
            ReleaseCache cache = (ReleaseCache)this.mapper.readValue(file.toFile(), ReleaseCache.class);
            this.log.debug((CharSequence)("Github cache found at " + file));
            return Optional.of(cache);
        }
        catch (IOException e) {
            this.log.warn((CharSequence)("Failed to read cache from " + file), (Throwable)e);
            try {
                Files.delete(file);
            }
            catch (IOException e2) {
                this.log.warn((CharSequence)("Failed to delete invalid cache file " + file), (Throwable)e2);
            }
            return Optional.empty();
        }
    }

    @Generated
    public Github(Log log, Path tmpDir, String userAgent) {
        this.log = log;
        this.tmpDir = tmpDir;
        this.userAgent = userAgent;
    }
}

