/*
 * Decompiled with CFR 0.152.
 */
package io.kokuwa.maven.helm;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.MatchPatterns;

public abstract class AbstractChartDirectoryMojo
extends AbstractMojo {
    @Parameter(property="helm.skip", defaultValue="false")
    protected boolean skip;
    @Parameter(property="helm.excludes")
    private String[] excludes;
    @Parameter(property="helm.chartDirectory", required=true)
    private File chartDirectory;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    List<Path> getChartDirectories() throws MojoExecutionException {
        ArrayList<String> exclusions = new ArrayList<String>();
        if (this.excludes != null) {
            exclusions.addAll(Arrays.asList(this.excludes));
        }
        exclusions.addAll(FileUtils.getDefaultExcludesAsList());
        MatchPatterns exclusionPatterns = MatchPatterns.from(exclusions);
        try (Stream<Path> files = Files.walk(this.chartDirectory.toPath(), FileVisitOption.FOLLOW_LINKS);){
            List<Path> chartDirectories = files.filter(p -> p.getFileName().toString().equalsIgnoreCase("chart.yaml")).map(Path::getParent).filter(p -> !exclusionPatterns.matches(p.toString(), false)).sorted(Comparator.reverseOrder()).collect(Collectors.toList());
            if (chartDirectories.isEmpty()) {
                this.getLog().warn((CharSequence)("No Charts detected - no Chart.yaml files found below " + this.chartDirectory));
            }
            List<Path> list = chartDirectories;
            return list;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to scan chart directory at " + this.chartDirectory, (Exception)e);
        }
    }

    @Generated
    public boolean isSkip() {
        return this.skip;
    }

    @Generated
    public String[] getExcludes() {
        return this.excludes;
    }

    @Generated
    public File getChartDirectory() {
        return this.chartDirectory;
    }

    @Generated
    public AbstractChartDirectoryMojo setSkip(boolean skip) {
        this.skip = skip;
        return this;
    }

    @Generated
    public AbstractChartDirectoryMojo setExcludes(String[] excludes) {
        this.excludes = excludes;
        return this;
    }

    @Generated
    public AbstractChartDirectoryMojo setChartDirectory(File chartDirectory) {
        this.chartDirectory = chartDirectory;
        return this;
    }
}

