/*
 * Decompiled with CFR 0.152.
 */
package io.kokuwa.maven.helm;

import io.kokuwa.maven.helm.AbstractChartDirectoryMojo;
import io.kokuwa.maven.helm.github.Github;
import io.kokuwa.maven.helm.pojo.HelmExecutable;
import io.kokuwa.maven.helm.pojo.HelmRepository;
import io.kokuwa.maven.helm.pojo.K8SCluster;
import java.io.File;
import java.io.IOException;
import java.net.PasswordAuthentication;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.plexus.components.sec.dispatcher.DefaultSecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;

public abstract class AbstractHelmMojo
extends AbstractChartDirectoryMojo {
    private final Path helmExecutableName = Paths.get(Os.isFamily((String)"windows") ? "helm.exe" : "helm", new String[0]);
    @Component(role=SecDispatcher.class, hint="default")
    private SecDispatcher securityDispatcher;
    @Component
    protected MavenProjectHelper mavenProjectHelper;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject mavenProject;
    @Parameter(property="helm.useLocalHelmBinary", defaultValue="false")
    private boolean useLocalHelmBinary;
    @Parameter(property="helm.autoDetectLocalHelmBinary", defaultValue="true")
    private boolean autoDetectLocalHelmBinary;
    @Parameter(property="helm.executableDirectory", defaultValue="${project.build.directory}/helm")
    private File helmExecutableDirectory;
    @Parameter(property="helm.outputDirectory", defaultValue="${project.build.directory}/helm/repo")
    private File outputDirectory;
    @Parameter(property="helm.chartVersion")
    private String chartVersion;
    @Parameter
    private HelmRepository uploadRepoStable;
    @Parameter
    private HelmRepository uploadRepoSnapshot;
    @Parameter(property="helm.version")
    private String helmVersion;
    @Parameter(property="helm.githubUserAgent", defaultValue="kokuwaio/helm-maven-plugin")
    private String githubUserAgent;
    @Parameter(property="helm.cacheValidityDays", defaultValue="1")
    private Integer cacheValidityDays;
    @Parameter(property="helm.tmpDir", defaultValue="${java.io.tmpdir}/helm-maven-plugin")
    private File tmpDir;
    @Parameter(property="helm.debug", defaultValue="false")
    private boolean debug;
    @Parameter(property="helm.registryConfig")
    private File registryConfig;
    @Parameter(property="helm.repositoryCache")
    private File repositoryCache;
    @Parameter(property="helm.repositoryConfig")
    private File repositoryConfig;
    @Parameter(property="helm.security", defaultValue="~/.m2/settings-security.xml")
    private String helmSecurity;
    @Parameter(property="helm.plain-http", defaultValue="false")
    private boolean plainHttp;
    @Deprecated
    @Parameter
    private K8SCluster k8sCluster;
    @Parameter(defaultValue="${settings}", readonly=true)
    protected Settings settings;
    @Parameter(property="helm.namespace")
    private String namespace;
    @Parameter(property="helm.kubeApiServer")
    private String kubeApiServer;
    @Parameter(property="helm.kubeInsecure")
    private boolean kubeInsecure;
    @Parameter(property="helm.kubeAsUser")
    private String kubeAsUser;
    @Parameter(property="helm.kubeAsGroup")
    private String kubeAsGroup;
    @Parameter(property="helm.kubeToken")
    private String kubeToken;
    @Parameter(property="helm.kubeCaFile")
    private File kubeCaFile;

    Path getHelmExecutablePath() throws MojoExecutionException {
        Stream<Path> optional;
        if (this.useLocalHelmBinary && this.autoDetectLocalHelmBinary) {
            optional = Stream.of(System.getenv("PATH").split(Pattern.quote(File.pathSeparator))).map(x$0 -> Paths.get(x$0, new String[0]));
            if (this.helmExecutableDirectory != null) {
                optional = Stream.concat(optional, Stream.of(this.helmExecutableDirectory.toPath()));
            }
        } else {
            optional = Stream.of(this.helmExecutableDirectory.toPath());
        }
        return optional.map(directory -> directory.resolve(this.helmExecutableName)).map(Path::toAbsolutePath).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(Files::isExecutable).findFirst().orElseThrow(() -> new MojoExecutionException("Helm executable not found."));
    }

    HelmExecutable helm() throws MojoExecutionException {
        HelmExecutable helm = new HelmExecutable(this.getLog(), this.getHelmExecutablePath());
        if (this.k8sCluster != null) {
            boolean logDeprecated = false;
            if (StringUtils.isNotEmpty((String)this.k8sCluster.getApiUrl())) {
                helm.flag("kube-apiserver", this.k8sCluster.getApiUrl());
                logDeprecated = true;
            }
            if (StringUtils.isNotEmpty((String)this.k8sCluster.getNamespace())) {
                helm.flag("namespace", this.k8sCluster.getNamespace());
                logDeprecated = true;
            }
            if (StringUtils.isNotEmpty((String)this.k8sCluster.getAsUser())) {
                helm.flag("kube-as-user", this.k8sCluster.getAsUser());
                logDeprecated = true;
            }
            if (StringUtils.isNotEmpty((String)this.k8sCluster.getAsGroup())) {
                helm.flag("kube-as-group", this.k8sCluster.getAsGroup());
                logDeprecated = true;
            }
            if (StringUtils.isNotEmpty((String)this.k8sCluster.getToken())) {
                helm.flag("kube-token", this.k8sCluster.getToken());
                logDeprecated = true;
            }
            if (logDeprecated) {
                this.getLog().warn((CharSequence)"NOTE: <k8sCluster> option will be removed in future major release.");
            }
        }
        return helm.flag("debug", this.debug).flag("kube-apiserver", this.kubeApiServer).flag("kube-as-group", this.kubeAsGroup).flag("kube-as-user", this.kubeAsUser).flag("kube-ca-file", this.kubeCaFile).flag("kube-insecure-skip-tls-verify", this.kubeInsecure).flag("kube-token", this.kubeToken).flag("namespace", this.namespace).flag("registry-config", this.registryConfig).flag("repository-cache", this.repositoryCache).flag("repository-config", this.repositoryConfig);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    List<Path> getChartArchives() throws MojoExecutionException {
        try (Stream<Path> files = Files.walk(this.getOutputDirectory(), new FileVisitOption[0]);){
            List<Path> list = files.filter(s -> Stream.of(".tgz", "tgz.prov").anyMatch(e -> s.getFileName().toString().endsWith((String)e))).peek(p -> this.getLog().debug((CharSequence)("Found chart file for upload: " + p))).collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to scan repo directory at " + this.outputDirectory, (Exception)e);
        }
    }

    HelmRepository getHelmUploadRepo() {
        if (this.chartVersion != null && this.chartVersion.endsWith("-SNAPSHOT") && this.uploadRepoSnapshot != null && StringUtils.isNotEmpty((String)this.uploadRepoSnapshot.getUrl())) {
            return this.uploadRepoSnapshot;
        }
        return this.uploadRepoStable;
    }

    PasswordAuthentication getAuthentication(HelmRepository repository) throws IllegalArgumentException, MojoExecutionException {
        String id = repository.getName();
        if (repository.getUsername() != null) {
            if (repository.getPassword() == null) {
                throw new IllegalArgumentException("Repo " + id + " has a username but no password defined.");
            }
            this.getLog().debug((CharSequence)("Repo " + id + " has credentials defined, skip searching in server list."));
            return new PasswordAuthentication(repository.getUsername(), repository.getPassword().toCharArray());
        }
        Server server = this.settings.getServer(id);
        if (server == null) {
            this.getLog().info((CharSequence)("No credentials found for " + id + " in configuration or settings.xml server list."));
            return null;
        }
        this.getLog().debug((CharSequence)("Use credentials from server list for " + id + "."));
        if (server.getUsername() == null || server.getPassword() == null) {
            throw new IllegalArgumentException("Repo " + id + " was found in server list but has no username/password.");
        }
        try {
            if (this.securityDispatcher instanceof DefaultSecDispatcher) {
                ((DefaultSecDispatcher)this.securityDispatcher).setConfigurationFile(this.helmSecurity);
            }
            return new PasswordAuthentication(server.getUsername(), this.securityDispatcher.decrypt(server.getPassword()).toCharArray());
        }
        catch (SecDispatcherException e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }

    public String getHelmVersion() throws MojoExecutionException {
        if (this.helmVersion == null) {
            this.helmVersion = new Github(this.getLog(), this.tmpDir.toPath(), this.githubUserAgent, this.cacheValidityDays).getHelmVersion();
        }
        return this.helmVersion;
    }

    public boolean isPlainHttp(Boolean mojoPlainHttp) {
        return mojoPlainHttp != null ? mojoPlainHttp : this.plainHttp;
    }

    public Path getOutputDirectory() {
        return this.outputDirectory.toPath();
    }

    public Path getHelmExecutableDirectory() {
        return this.helmExecutableDirectory.toPath();
    }

    @Generated
    public Path getHelmExecutableName() {
        return this.helmExecutableName;
    }

    @Generated
    public SecDispatcher getSecurityDispatcher() {
        return this.securityDispatcher;
    }

    @Generated
    public MavenProjectHelper getMavenProjectHelper() {
        return this.mavenProjectHelper;
    }

    @Generated
    public MavenProject getMavenProject() {
        return this.mavenProject;
    }

    @Generated
    public boolean isUseLocalHelmBinary() {
        return this.useLocalHelmBinary;
    }

    @Generated
    public boolean isAutoDetectLocalHelmBinary() {
        return this.autoDetectLocalHelmBinary;
    }

    @Generated
    public String getChartVersion() {
        return this.chartVersion;
    }

    @Generated
    public HelmRepository getUploadRepoStable() {
        return this.uploadRepoStable;
    }

    @Generated
    public HelmRepository getUploadRepoSnapshot() {
        return this.uploadRepoSnapshot;
    }

    @Generated
    public String getGithubUserAgent() {
        return this.githubUserAgent;
    }

    @Generated
    public Integer getCacheValidityDays() {
        return this.cacheValidityDays;
    }

    @Generated
    public File getTmpDir() {
        return this.tmpDir;
    }

    @Generated
    public boolean isDebug() {
        return this.debug;
    }

    @Generated
    public File getRegistryConfig() {
        return this.registryConfig;
    }

    @Generated
    public File getRepositoryCache() {
        return this.repositoryCache;
    }

    @Generated
    public File getRepositoryConfig() {
        return this.repositoryConfig;
    }

    @Generated
    public String getHelmSecurity() {
        return this.helmSecurity;
    }

    @Generated
    public boolean isPlainHttp() {
        return this.plainHttp;
    }

    @Deprecated
    @Generated
    public K8SCluster getK8sCluster() {
        return this.k8sCluster;
    }

    @Generated
    public Settings getSettings() {
        return this.settings;
    }

    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @Generated
    public String getKubeApiServer() {
        return this.kubeApiServer;
    }

    @Generated
    public boolean isKubeInsecure() {
        return this.kubeInsecure;
    }

    @Generated
    public String getKubeAsUser() {
        return this.kubeAsUser;
    }

    @Generated
    public String getKubeAsGroup() {
        return this.kubeAsGroup;
    }

    @Generated
    public String getKubeToken() {
        return this.kubeToken;
    }

    @Generated
    public File getKubeCaFile() {
        return this.kubeCaFile;
    }

    @Generated
    public AbstractHelmMojo setSecurityDispatcher(SecDispatcher securityDispatcher) {
        this.securityDispatcher = securityDispatcher;
        return this;
    }

    @Generated
    public AbstractHelmMojo setMavenProjectHelper(MavenProjectHelper mavenProjectHelper) {
        this.mavenProjectHelper = mavenProjectHelper;
        return this;
    }

    @Generated
    public AbstractHelmMojo setMavenProject(MavenProject mavenProject) {
        this.mavenProject = mavenProject;
        return this;
    }

    @Generated
    public AbstractHelmMojo setUseLocalHelmBinary(boolean useLocalHelmBinary) {
        this.useLocalHelmBinary = useLocalHelmBinary;
        return this;
    }

    @Generated
    public AbstractHelmMojo setAutoDetectLocalHelmBinary(boolean autoDetectLocalHelmBinary) {
        this.autoDetectLocalHelmBinary = autoDetectLocalHelmBinary;
        return this;
    }

    @Generated
    public AbstractHelmMojo setHelmExecutableDirectory(File helmExecutableDirectory) {
        this.helmExecutableDirectory = helmExecutableDirectory;
        return this;
    }

    @Generated
    public AbstractHelmMojo setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
        return this;
    }

    @Generated
    public AbstractHelmMojo setChartVersion(String chartVersion) {
        this.chartVersion = chartVersion;
        return this;
    }

    @Generated
    public AbstractHelmMojo setUploadRepoStable(HelmRepository uploadRepoStable) {
        this.uploadRepoStable = uploadRepoStable;
        return this;
    }

    @Generated
    public AbstractHelmMojo setUploadRepoSnapshot(HelmRepository uploadRepoSnapshot) {
        this.uploadRepoSnapshot = uploadRepoSnapshot;
        return this;
    }

    @Generated
    public AbstractHelmMojo setHelmVersion(String helmVersion) {
        this.helmVersion = helmVersion;
        return this;
    }

    @Generated
    public AbstractHelmMojo setGithubUserAgent(String githubUserAgent) {
        this.githubUserAgent = githubUserAgent;
        return this;
    }

    @Generated
    public AbstractHelmMojo setCacheValidityDays(Integer cacheValidityDays) {
        this.cacheValidityDays = cacheValidityDays;
        return this;
    }

    @Generated
    public AbstractHelmMojo setTmpDir(File tmpDir) {
        this.tmpDir = tmpDir;
        return this;
    }

    @Generated
    public AbstractHelmMojo setDebug(boolean debug) {
        this.debug = debug;
        return this;
    }

    @Generated
    public AbstractHelmMojo setRegistryConfig(File registryConfig) {
        this.registryConfig = registryConfig;
        return this;
    }

    @Generated
    public AbstractHelmMojo setRepositoryCache(File repositoryCache) {
        this.repositoryCache = repositoryCache;
        return this;
    }

    @Generated
    public AbstractHelmMojo setRepositoryConfig(File repositoryConfig) {
        this.repositoryConfig = repositoryConfig;
        return this;
    }

    @Generated
    public AbstractHelmMojo setHelmSecurity(String helmSecurity) {
        this.helmSecurity = helmSecurity;
        return this;
    }

    @Generated
    public AbstractHelmMojo setPlainHttp(boolean plainHttp) {
        this.plainHttp = plainHttp;
        return this;
    }

    @Deprecated
    @Generated
    public AbstractHelmMojo setK8sCluster(K8SCluster k8sCluster) {
        this.k8sCluster = k8sCluster;
        return this;
    }

    @Generated
    public AbstractHelmMojo setSettings(Settings settings) {
        this.settings = settings;
        return this;
    }

    @Generated
    public AbstractHelmMojo setNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    @Generated
    public AbstractHelmMojo setKubeApiServer(String kubeApiServer) {
        this.kubeApiServer = kubeApiServer;
        return this;
    }

    @Generated
    public AbstractHelmMojo setKubeInsecure(boolean kubeInsecure) {
        this.kubeInsecure = kubeInsecure;
        return this;
    }

    @Generated
    public AbstractHelmMojo setKubeAsUser(String kubeAsUser) {
        this.kubeAsUser = kubeAsUser;
        return this;
    }

    @Generated
    public AbstractHelmMojo setKubeAsGroup(String kubeAsGroup) {
        this.kubeAsGroup = kubeAsGroup;
        return this;
    }

    @Generated
    public AbstractHelmMojo setKubeToken(String kubeToken) {
        this.kubeToken = kubeToken;
        return this;
    }

    @Generated
    public AbstractHelmMojo setKubeCaFile(File kubeCaFile) {
        this.kubeCaFile = kubeCaFile;
        return this;
    }
}

