/*
 * Decompiled with CFR 0.152.
 */
package io.kokuwa.maven.helm;

import io.kokuwa.maven.helm.AbstractChartDirectoryMojo;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.stream.Stream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="clean", defaultPhase=LifecyclePhase.CLEAN, threadSafe=true)
public class CleanMojo
extends AbstractChartDirectoryMojo {
    @Parameter(property="helm.clean.skip", defaultValue="false")
    private boolean skipClean;
    @Parameter(property="helm.clean.failOnError", defaultValue="true")
    private boolean cleanFailOnError;

    public void execute() throws MojoExecutionException {
        if (this.skip || this.skipClean) {
            this.getLog().info((CharSequence)"Skip clean");
            return;
        }
        for (Path chartDirectory : this.getChartDirectories()) {
            this.getLog().info((CharSequence)("Cleanups chart " + chartDirectory + "..."));
            Path chartsPath = chartDirectory.resolve("charts");
            if (!Files.exists(chartsPath, new LinkOption[0])) continue;
            try {
                try (Stream<Path> paths = Files.walk(chartsPath, new FileVisitOption[0]);){
                    paths.sorted(Comparator.reverseOrder()).forEach(this::delete);
                }
                this.delete(chartDirectory.resolve("Chart.lock"));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to cleanups chart " + chartDirectory, (Exception)e);
            }
        }
    }

    private void delete(Path path) {
        try {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Deleting " + path));
            }
            Files.deleteIfExists(path);
        }
        catch (IOException e) {
            if (this.cleanFailOnError) {
                throw new UncheckedIOException(e);
            }
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Failed to delete " + path), (Throwable)e);
            }
            this.getLog().warn((CharSequence)("Failed to delete " + path + ": " + e.getMessage()));
        }
    }
}

