/*
 * Decompiled with CFR 0.152.
 */
package io.kokuwa.maven.helm;

import io.kokuwa.maven.helm.AbstractDependencyMojo;
import io.kokuwa.maven.helm.pojo.HelmExecutable;
import java.nio.file.Path;
import lombok.Generated;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="dependency-update", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, threadSafe=true)
public class DependencyUpdateMojo
extends AbstractDependencyMojo {
    @Parameter(property="helm.dependency-update.skip", defaultValue="false")
    private boolean skipDependencyUpdate;
    @Parameter(property="helm.dependency-update.skip-repo-refresh", defaultValue="false")
    private boolean skipDependencyUpdateRepoRefresh;

    public void execute() throws MojoExecutionException {
        if (this.skip || this.skipDependencyUpdate) {
            this.getLog().info((CharSequence)"Skip dependency update");
            return;
        }
        for (Path chartDirectory : this.getChartDirectories()) {
            this.doOverwriteLocalDependencies(chartDirectory);
            this.getLog().info((CharSequence)("Updating chart dependencies for " + chartDirectory + " ..."));
            HelmExecutable helm = this.helm().arguments("dependency", "update", chartDirectory);
            if (this.skipDependencyUpdateRepoRefresh) {
                helm.flag("skip-refresh");
            }
            helm.execute("Failed to resolve dependencies");
        }
    }

    @Generated
    public DependencyUpdateMojo setSkipDependencyUpdate(boolean skipDependencyUpdate) {
        this.skipDependencyUpdate = skipDependencyUpdate;
        return this;
    }

    @Generated
    public DependencyUpdateMojo setSkipDependencyUpdateRepoRefresh(boolean skipDependencyUpdateRepoRefresh) {
        this.skipDependencyUpdateRepoRefresh = skipDependencyUpdateRepoRefresh;
        return this;
    }
}

