/*
 * Decompiled with CFR 0.152.
 */
package io.kokuwa.maven.helm;

import io.kokuwa.maven.helm.AbstractHelmMojo;
import io.kokuwa.maven.helm.pojo.HelmRepository;
import java.io.File;
import java.net.PasswordAuthentication;
import java.nio.file.Path;
import lombok.Generated;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="push", defaultPhase=LifecyclePhase.DEPLOY, threadSafe=true)
public class PushMojo
extends AbstractHelmMojo {
    @Parameter(property="helm.push.caFile")
    private File caFile;
    @Parameter(property="helm.push.insecure", defaultValue="false")
    private boolean insecure;
    @Parameter(property="helm.push.plain-http")
    private Boolean pushPlainHttp;
    @Parameter(property="helm.push.skipLogin", defaultValue="false")
    private boolean skipPushLogin;
    @Parameter(property="helm.push.skip", defaultValue="false")
    private boolean skipPush;

    public void execute() throws MojoExecutionException {
        if (this.skip || this.skipPush) {
            this.getLog().info((CharSequence)"Skip push");
            return;
        }
        HelmRepository repository = this.getHelmUploadRepo();
        if (repository == null) {
            this.getLog().info((CharSequence)"there is no helm repo. skipping the upload.");
            return;
        }
        if (this.isUseLocalHelmBinary()) {
            this.getLog().debug((CharSequence)"helm version unknown");
        } else {
            ComparableVersion minimumHelmVersion;
            ComparableVersion helmVersion = new ComparableVersion(this.getHelmVersion());
            if (helmVersion.compareTo(minimumHelmVersion = new ComparableVersion("3.8.0")) < 0) {
                this.getLog().error((CharSequence)("your helm version is " + helmVersion + ", it's required to be >=3.8.0"));
                throw new IllegalStateException();
            }
            this.getLog().debug((CharSequence)("helm version minimum satisfied. the version is: " + helmVersion));
        }
        PasswordAuthentication authentication = this.getAuthentication(repository);
        if (!this.skipPushLogin && authentication != null) {
            this.getLog().warn((CharSequence)"Registry login with `helm:push` is deprecated and will beremoved in next major version. Please use `helm-registry-login` for registry login and set `helm.push.skipLogin` to `true`. For more information see https://github.com/kokuwaio/helm-maven-plugin/issues/302");
            this.helm().arguments("registry", "login", repository.getUrl()).flag("username", authentication.getUserName()).flag("password-stdin").setStdin(new String(authentication.getPassword())).execute("Failed to login into repository " + repository.getName() + " at " + repository.getUrl());
        }
        for (Path chartArchive : this.getChartArchives()) {
            this.getLog().info((CharSequence)("Uploading " + chartArchive + "..."));
            this.helm().arguments("push", chartArchive, "oci://" + repository.getUrl()).flag("ca-file", this.caFile).flag("insecure-skip-tls-verify", this.insecure).flag("plain-http", this.isPlainHttp(this.pushPlainHttp)).execute("Upload failed");
        }
    }

    @Generated
    public PushMojo setCaFile(File caFile) {
        this.caFile = caFile;
        return this;
    }

    @Generated
    public PushMojo setInsecure(boolean insecure) {
        this.insecure = insecure;
        return this;
    }

    @Generated
    public PushMojo setPushPlainHttp(Boolean pushPlainHttp) {
        this.pushPlainHttp = pushPlainHttp;
        return this;
    }

    @Generated
    public PushMojo setSkipPushLogin(boolean skipPushLogin) {
        this.skipPushLogin = skipPushLogin;
        return this;
    }

    @Generated
    public PushMojo setSkipPush(boolean skipPush) {
        this.skipPush = skipPush;
        return this;
    }
}

