/*
 * Decompiled with CFR 0.152.
 */
package io.kokuwa.maven.helm.util;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import io.kokuwa.maven.helm.pojo.HelmChart;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public class DependencyOverwriter {
    private static final ObjectMapper MAPPER = new YAMLMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private final Log log;
    private final String overwriteRepository;
    private final String overwriteVersion;
    private Path writeDirectory;

    public DependencyOverwriter(String overwriteRepository, String overwriteVersion, Log log) {
        this.overwriteRepository = overwriteRepository;
        this.overwriteVersion = overwriteVersion;
        this.log = log;
    }

    public void setWriteDirectory(Path writeDirectory) {
        this.writeDirectory = writeDirectory;
    }

    public void execute(Path directory) throws MojoExecutionException {
        List<HelmChart.Dependency> dependencies;
        Path chartFile = directory.resolve("Chart.yaml");
        if (!Files.isRegularFile(chartFile, new LinkOption[0])) {
            this.log.warn((CharSequence)("No Charts detected - no Chart.yaml files found below " + directory));
            return;
        }
        try {
            dependencies = ((HelmChart)MAPPER.readValue(chartFile.toFile(), HelmChart.class)).getDependencies();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to read chart dependencies from " + chartFile, (Exception)e);
        }
        if (dependencies == null || dependencies.isEmpty()) {
            this.log.info((CharSequence)("No dependencies found for " + chartFile));
            return;
        }
        for (HelmChart.Dependency dependency : dependencies) {
            if (dependency.getRepository() == null || !dependency.getRepository().startsWith("file://")) continue;
            dependency.setOverwrite(true);
        }
        if (dependencies.stream().anyMatch(HelmChart.Dependency::isOverwrite)) {
            this.overwriteDependencies(dependencies, directory, chartFile);
        }
    }

    private void overwriteDependencies(List<HelmChart.Dependency> dependencies, Path directory, Path chartFile) throws MojoExecutionException {
        List<String> originalChart;
        Path chartLock = directory.resolve("Chart.lock");
        try {
            if (Files.deleteIfExists(chartLock)) {
                this.log.info((CharSequence)("Lock deleted at " + chartLock));
            } else {
                this.log.info((CharSequence)("No lock file found at " + chartLock));
            }
        }
        catch (IOException e) {
            this.log.warn((CharSequence)("Failed to delete " + chartLock));
        }
        ArrayList<String> overwrittenChart = new ArrayList<String>();
        try {
            originalChart = Files.readAllLines(chartFile, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to read " + chartFile, (Exception)e);
        }
        boolean isDependencies = false;
        boolean repository = false;
        boolean version = false;
        boolean name = false;
        Iterator<HelmChart.Dependency> dependencyIterator = dependencies.iterator();
        HelmChart.Dependency currentDependency = dependencyIterator.next();
        for (String line : originalChart) {
            if (isDependencies) {
                if (line.contains("version:")) {
                    version = true;
                    if (currentDependency.isOverwrite() && this.overwriteVersion != null && !this.overwriteVersion.isEmpty()) {
                        this.log.info((CharSequence)("Overwriting dependency '" + currentDependency.getName() + "' with new version:"));
                        this.log.info((CharSequence)"\tOld Value:");
                        this.log.info((CharSequence)line);
                        line = line.replace(currentDependency.getVersion(), this.overwriteVersion);
                        this.log.info((CharSequence)"\tNew Value:");
                        this.log.info((CharSequence)line);
                    }
                } else if (line.contains("repository:")) {
                    repository = true;
                    if (currentDependency.isOverwrite()) {
                        this.log.info((CharSequence)("Overwriting dependency '" + currentDependency.getName() + "' with new repository:"));
                        this.log.info((CharSequence)"\tOld Value:");
                        this.log.info((CharSequence)line);
                        line = line.replace(currentDependency.getRepository(), this.overwriteRepository);
                        this.log.info((CharSequence)"\tNew Value:");
                        this.log.info((CharSequence)line);
                    }
                } else if (line.contains("name:")) {
                    name = true;
                }
                if (currentDependency.getRepository() == null) {
                    repository = true;
                }
                if (name && version && repository) {
                    repository = false;
                    version = false;
                    name = false;
                    if (dependencyIterator.hasNext()) {
                        currentDependency = dependencyIterator.next();
                    } else {
                        isDependencies = false;
                    }
                }
            } else if (line.contains("dependencies:")) {
                isDependencies = true;
            }
            overwrittenChart.add(line);
        }
        try {
            Path path = this.writeDirectory != null ? this.writeDirectory.resolve("Chart.yaml") : chartFile;
            Files.write(path, overwrittenChart, StandardCharsets.UTF_8, new OpenOption[0]);
            this.log.info((CharSequence)("Overwriting successful for " + path));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to overwrite Chart.yaml at " + directory, (Exception)e);
        }
    }
}

