/*
 * Decompiled with CFR 0.152.
 */
package io.kokuwa.maven.helm;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.logging.Log;

public class StripSensitiveDataLog
implements Log {
    private static final Pattern HELM_PASSWORD = Pattern.compile("^.*--password=(?<secret>[^-\\s]+).*$");
    private static final Pattern KUBE_TOKEN = Pattern.compile("^.*--kube-token=(?<secret>[^-\\s]+).*$");
    private static final List<Pattern> PATTERNS = Arrays.asList(HELM_PASSWORD, KUBE_TOKEN);
    private static final String REPLACEMENT = "*****";
    private final Log delegate;

    static String strip(CharSequence content) {
        String stripped = content.toString();
        for (Pattern pattern : PATTERNS) {
            Matcher matcher = pattern.matcher(content);
            if (!matcher.matches()) continue;
            stripped = stripped.replace(matcher.group("secret"), REPLACEMENT);
        }
        return stripped;
    }

    public StripSensitiveDataLog(Log delegate) {
        this.delegate = delegate;
    }

    public void debug(CharSequence content) {
        this.delegate.debug((CharSequence)StripSensitiveDataLog.strip(content));
    }

    public void debug(CharSequence content, Throwable error) {
        this.delegate.debug((CharSequence)StripSensitiveDataLog.strip(content), error);
    }

    public void debug(Throwable error) {
        this.delegate.debug(error);
    }

    public void info(CharSequence content) {
        this.delegate.info((CharSequence)StripSensitiveDataLog.strip(content));
    }

    public void info(CharSequence content, Throwable error) {
        this.delegate.info((CharSequence)StripSensitiveDataLog.strip(content), error);
    }

    public void info(Throwable error) {
        this.delegate.info(error);
    }

    public void warn(CharSequence content) {
        this.delegate.warn((CharSequence)StripSensitiveDataLog.strip(content));
    }

    public void warn(CharSequence content, Throwable error) {
        this.delegate.warn((CharSequence)StripSensitiveDataLog.strip(content), error);
    }

    public void warn(Throwable error) {
        this.delegate.warn(error);
    }

    public void error(CharSequence content) {
        this.delegate.error((CharSequence)StripSensitiveDataLog.strip(content));
    }

    public void error(CharSequence content, Throwable error) {
        this.delegate.error((CharSequence)StripSensitiveDataLog.strip(content), error);
    }

    public void error(Throwable error) {
        this.delegate.error(error);
    }

    public boolean isDebugEnabled() {
        return this.delegate.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.delegate.isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return this.delegate.isWarnEnabled();
    }

    public boolean isErrorEnabled() {
        return this.delegate.isErrorEnabled();
    }
}

