/*
 * Decompiled with CFR 0.152.
 */
package io.kokuwa.maven.helm;

import io.kokuwa.maven.helm.AbstractHelmMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="package", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true)
public class PackageMojo
extends AbstractHelmMojo {
    @Parameter(property="helm.package.skip", defaultValue="false")
    private boolean skipPackage;
    @Parameter(property="helm.package.keyring")
    private String keyring;
    @Parameter(property="helm.package.key")
    private String key;
    @Parameter(property="helm.package.passphrase")
    private String passphrase;

    public void execute() throws MojoExecutionException {
        if (this.skip || this.skipPackage) {
            this.getLog().info((CharSequence)"Skip package");
            return;
        }
        for (String inputDirectory : this.getChartDirectories(this.getChartDirectory())) {
            this.getLog().info((CharSequence)("Packaging chart " + inputDirectory + "..."));
            String arguments = "package " + inputDirectory + " -d " + this.getOutputDirectory();
            if (this.getChartVersion() != null) {
                this.getLog().info((CharSequence)String.format("Setting chart version to %s", this.getChartVersionWithProcessing()));
                arguments = arguments + " --version " + this.getChartVersionWithProcessing();
            }
            if (this.getAppVersion() != null) {
                this.getLog().info((CharSequence)String.format("Setting App version to %s", this.getAppVersion()));
                arguments = arguments + " --app-version " + this.getAppVersion();
            }
            String stdin = null;
            if (this.isSignEnabled()) {
                this.getLog().info((CharSequence)"Enable signing");
                arguments = arguments + " --sign --keyring " + this.keyring + " --key " + this.key;
                if (StringUtils.isNotEmpty((String)this.passphrase)) {
                    arguments = arguments + " --passphrase-file -";
                    stdin = this.passphrase;
                }
            }
            this.helm(arguments, "Unable to package chart at " + inputDirectory, stdin);
        }
    }

    private boolean isSignEnabled() {
        return StringUtils.isNotEmpty((String)this.keyring) && StringUtils.isNotEmpty((String)this.key);
    }

    public PackageMojo setSkipPackage(boolean skipPackage) {
        this.skipPackage = skipPackage;
        return this;
    }

    public PackageMojo setKeyring(String keyring) {
        this.keyring = keyring;
        return this;
    }

    public PackageMojo setKey(String key) {
        this.key = key;
        return this;
    }

    public PackageMojo setPassphrase(String passphrase) {
        this.passphrase = passphrase;
        return this;
    }
}

