/*
 * Decompiled with CFR 0.152.
 */
package io.kokuwa.maven.helm;

import io.kokuwa.maven.helm.StripSensitiveDataLog;
import io.kokuwa.maven.helm.github.Github;
import io.kokuwa.maven.helm.pojo.HelmRepository;
import io.kokuwa.maven.helm.pojo.K8SCluster;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.PasswordAuthentication;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Clock;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.MatchPatterns;
import org.sonatype.plexus.components.sec.dispatcher.DefaultSecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;

public abstract class AbstractHelmMojo
extends AbstractMojo {
    @Component(role=SecDispatcher.class, hint="default")
    private SecDispatcher securityDispatcher;
    @Parameter(property="helm.useLocalHelmBinary", defaultValue="false")
    private boolean useLocalHelmBinary;
    @Parameter(property="helm.autoDetectLocalHelmBinary", defaultValue="true")
    private boolean autoDetectLocalHelmBinary;
    @Parameter(property="helm.executableDirectory", defaultValue="${project.build.directory}/helm")
    private String helmExecutableDirectory;
    @Parameter(property="helm.outputDirectory", defaultValue="${project.build.directory}/helm/repo")
    private String outputDirectory;
    @Parameter(property="helm.excludes")
    private String[] excludes;
    @Parameter(property="helm.chartDirectory", required=true)
    private String chartDirectory;
    @Parameter(property="helm.chartVersion")
    private String chartVersion;
    @Parameter(property="helm.chartVersion.timestampOnSnapshot")
    private boolean timestampOnSnapshot;
    @Parameter(property="helm.chartVersion.timestampFormat", defaultValue="yyyyMMddHHmmss")
    private String timestampFormat;
    @Parameter(property="helm.appVersion")
    private String appVersion;
    @Parameter(property="helm.uploadRepo.stable")
    private HelmRepository uploadRepoStable;
    @Parameter(property="helm.uploadRepo.snapshot")
    private HelmRepository uploadRepoSnapshot;
    @Parameter(property="helm.downloadUrl")
    private String helmDownloadUrl;
    @Parameter(property="helm.version")
    private String helmVersion;
    @Parameter(property="helm.githubUserAgent", defaultValue="kokuwaio/helm-maven-plugin")
    private String githubUserAgent;
    @Parameter(property="helm.tmpDir", defaultValue="${java.io.tmpdir}/helm-maven-plugin")
    private String tmpDir;
    @Parameter(property="helm.debug", defaultValue="false")
    private boolean debug;
    @Parameter(property="helm.registryConfig")
    private String registryConfig;
    @Parameter(property="helm.repositoryCache")
    private String repositoryCache;
    @Parameter(property="helm.repositoryConfig")
    private String repositoryConfig;
    @Parameter(property="helm.extraRepos")
    private HelmRepository[] helmExtraRepos;
    @Parameter(property="helm.security", defaultValue="~/.m2/settings-security.xml")
    private String helmSecurity;
    @Parameter(property="helm.skip", defaultValue="false")
    protected boolean skip;
    @Parameter(property="helm.k8s")
    private K8SCluster k8sCluster;
    @Parameter(defaultValue="${settings}", readonly=true)
    private Settings settings;
    @Parameter(defaultValue="${project.groupId}", readonly=true)
    private String projectGroupId;
    @Parameter(defaultValue="${project.version}", readonly=true)
    private String projectVersion;
    @Parameter(property="helm.namespace")
    private String namespace;
    @Parameter(property="helm.kubeApiServer")
    private String kubeApiServer;
    @Parameter(property="helm.kubeAsUser")
    private String kubeAsUser;
    @Parameter(property="helm.kubeAsGroup")
    private String kubeAsGroup;
    @Parameter(property="helm.kubeToken")
    private String kubeToken;
    @Parameter(property="helm.kubeCaFile")
    private String kubeCaFile;
    private Clock clock = Clock.systemDefaultZone();

    public void setLog(Log log) {
        super.setLog((Log)new StripSensitiveDataLog(log));
    }

    Path getHelmExecuteablePath() throws MojoExecutionException {
        String helmExecutable = SystemUtils.IS_OS_WINDOWS ? "helm.exe" : "helm";
        Optional<Path> path = this.isUseLocalHelmBinary() && this.isAutoDetectLocalHelmBinary() ? this.findInPath(helmExecutable) : Optional.of(Paths.get(this.helmExecutableDirectory, helmExecutable)).map(Path::toAbsolutePath).filter(x$0 -> Files.exists(x$0, new LinkOption[0]));
        return path.orElseThrow(() -> new MojoExecutionException("Helm executable is not found."));
    }

    private Optional<Path> findInPath(String executable) {
        String[] paths = this.getPathsFromEnvironmentVariables();
        return Stream.of(paths).map(x$0 -> Paths.get(x$0, new String[0])).map(path -> path.resolve(executable)).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).map(Path::toAbsolutePath).findFirst();
    }

    String[] getPathsFromEnvironmentVariables() {
        return System.getenv("PATH").split(Pattern.quote(File.pathSeparator));
    }

    String getCurrentTimestamp() {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(this.getTimestampFormat());
        LocalDateTime currentTime = LocalDateTime.now(this.clock);
        return dateTimeFormatter.format(currentTime);
    }

    void helm(String arguments, String errorMessage) throws MojoExecutionException {
        this.helm(arguments, errorMessage, null);
    }

    void helm(String arguments, String errorMessage, String stdin) throws MojoExecutionException {
        int exitValue;
        StringBuilder command = new StringBuilder().append(this.getHelmExecuteablePath()).append(" ").append(arguments);
        if (this.debug) {
            command.append(" --debug");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.registryConfig)) {
            command.append(" --registry-config=").append(this.registryConfig);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.repositoryConfig)) {
            command.append(" --repository-config=").append(this.repositoryConfig);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.repositoryCache)) {
            command.append(" --repository-cache=").append(this.repositoryCache);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.namespace)) {
            command.append(" --namespace=").append(this.namespace);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.kubeApiServer)) {
            command.append(" --kube-apiserver=").append(this.kubeApiServer);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.kubeAsUser)) {
            command.append(" --kube-as-user=").append(this.kubeAsUser);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.kubeAsGroup)) {
            command.append(" --kube-as-group=").append(this.kubeAsGroup);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.kubeToken)) {
            command.append(" --kube-token=").append(this.kubeToken);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.kubeCaFile)) {
            command.append(" --kube-ca-file=").append(this.kubeCaFile);
        }
        String commandWithK8sArgs = command.append(this.getK8SArgs()).toString();
        this.getLog().debug((CharSequence)commandWithK8sArgs);
        this.warnOnMixOfK8sClusterAndGlobalFlags();
        try {
            Process p = Runtime.getRuntime().exec(commandWithK8sArgs);
            new Thread(() -> {
                if (StringUtils.isNotEmpty((CharSequence)stdin)) {
                    try (OutputStream outputStream = p.getOutputStream();){
                        outputStream.write(stdin.getBytes(StandardCharsets.UTF_8));
                    }
                    catch (IOException ex) {
                        this.getLog().error((CharSequence)"failed to write to stdin of helm", (Throwable)ex);
                    }
                }
                BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                try {
                    String inputLine;
                    while ((inputLine = input.readLine()) != null) {
                        this.getLog().info((CharSequence)inputLine);
                    }
                }
                catch (IOException e) {
                    this.getLog().error((Throwable)e);
                }
            }).start();
            new Thread(() -> {
                BufferedReader error = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                try {
                    String errorLine;
                    while ((errorLine = error.readLine()) != null) {
                        this.getLog().error((CharSequence)errorLine);
                    }
                }
                catch (IOException e) {
                    this.getLog().error((Throwable)e);
                }
            }).start();
            p.waitFor();
            exitValue = p.exitValue();
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("Error processing command [" + commandWithK8sArgs + "]"), (Throwable)e);
            throw new MojoExecutionException("Error processing command", e);
        }
        if (exitValue != 0) {
            throw new MojoExecutionException(errorMessage);
        }
    }

    String getK8SArgs() {
        StringBuilder k8sConfigArgs = new StringBuilder();
        if (this.k8sCluster != null) {
            if (StringUtils.isNotEmpty((CharSequence)this.k8sCluster.getApiUrl())) {
                k8sConfigArgs.append(" --kube-apiserver=").append(this.k8sCluster.getApiUrl());
            }
            if (StringUtils.isNotEmpty((CharSequence)this.k8sCluster.getNamespace())) {
                k8sConfigArgs.append(" --namespace=").append(this.k8sCluster.getNamespace());
            }
            if (StringUtils.isNotEmpty((CharSequence)this.k8sCluster.getAsUser())) {
                k8sConfigArgs.append(" --kube-as-user=").append(this.k8sCluster.getAsUser());
            }
            if (StringUtils.isNotEmpty((CharSequence)this.k8sCluster.getAsGroup())) {
                k8sConfigArgs.append(" --kube-as-group=").append(this.k8sCluster.getAsGroup());
            }
            if (StringUtils.isNotEmpty((CharSequence)this.k8sCluster.getToken())) {
                k8sConfigArgs.append(" --kube-token=").append(this.k8sCluster.getToken());
            }
            if (k8sConfigArgs.length() > 0) {
                this.getLog().warn((CharSequence)"NOTE: <k8sCluster> option will be removed in future major release.");
            }
        }
        return k8sConfigArgs.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    List<String> getChartDirectories(String path) throws MojoExecutionException {
        ArrayList<String> exclusions = new ArrayList<String>();
        if (this.getExcludes() != null) {
            exclusions.addAll(Arrays.asList(this.getExcludes()));
        }
        exclusions.addAll(FileUtils.getDefaultExcludesAsList());
        MatchPatterns exclusionPatterns = MatchPatterns.from(exclusions);
        try (Stream<Path> files = Files.walk(Paths.get(path, new String[0]), FileVisitOption.FOLLOW_LINKS);){
            List<String> chartDirs = files.filter(p -> p.getFileName().toString().equalsIgnoreCase("chart.yaml")).map(p -> p.getParent().toString()).filter(this.shouldIncludeDirectory(exclusionPatterns)).collect(Collectors.toList());
            if (chartDirs.isEmpty()) {
                this.getLog().warn((CharSequence)("No Charts detected - no Chart.yaml files found below " + path));
            }
            List<String> list = chartDirs;
            return list;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to scan chart directory at " + path, (Exception)e);
        }
    }

    private Predicate<String> shouldIncludeDirectory(MatchPatterns exclusionPatterns) {
        return inputDirectory -> {
            boolean isCaseSensitive = false;
            boolean matches = exclusionPatterns.matches(inputDirectory, isCaseSensitive);
            if (matches) {
                this.getLog().debug((CharSequence)("Skip excluded directory " + inputDirectory));
                return false;
            }
            return true;
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    List<String> getChartFiles(String path) throws MojoExecutionException {
        try (Stream<Path> files = Files.walk(Paths.get(path, new String[0]), new FileVisitOption[0]);){
            List<String> list = files.filter(this::isChartFile).map(Path::toString).collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to scan repo directory at " + path, (Exception)e);
        }
    }

    private boolean isChartFile(Path p) {
        String filename = p.getFileName().toString();
        return filename.endsWith(".tgz") || filename.endsWith("tgz.prov");
    }

    String getHelmUploadUrl() {
        String uploadUrl = this.uploadRepoStable.getUrl();
        if (this.chartVersion != null && this.chartVersion.endsWith("-SNAPSHOT") && this.uploadRepoSnapshot != null && StringUtils.isNotEmpty((CharSequence)this.uploadRepoSnapshot.getUrl())) {
            uploadUrl = this.uploadRepoSnapshot.getUrl();
        }
        return uploadUrl;
    }

    HelmRepository getHelmUploadRepo() {
        if (this.chartVersion != null && this.chartVersion.endsWith("-SNAPSHOT") && this.uploadRepoSnapshot != null && StringUtils.isNotEmpty((CharSequence)this.uploadRepoSnapshot.getUrl())) {
            return this.uploadRepoSnapshot;
        }
        return this.uploadRepoStable;
    }

    PasswordAuthentication getAuthentication(HelmRepository repository) throws IllegalArgumentException, MojoExecutionException {
        String id = repository.getName();
        if (repository.getUsername() != null) {
            if (repository.getPassword() == null) {
                throw new IllegalArgumentException("Repo " + id + " has a username but no password defined.");
            }
            this.getLog().debug((CharSequence)("Repo " + id + " has credentials defined, skip searching in server list."));
            return new PasswordAuthentication(repository.getUsername(), repository.getPassword().toCharArray());
        }
        Server server = this.settings.getServer(id);
        if (server == null) {
            this.getLog().info((CharSequence)("No credentials found for " + id + " in configuration or settings.xml server list."));
            return null;
        }
        this.getLog().debug((CharSequence)("Use credentials from server list for " + id + "."));
        if (server.getUsername() == null || server.getPassword() == null) {
            throw new IllegalArgumentException("Repo " + id + " was found in server list but has no username/password.");
        }
        try {
            return new PasswordAuthentication(server.getUsername(), this.getSecDispatcher().decrypt(server.getPassword()).toCharArray());
        }
        catch (SecDispatcherException e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }

    protected SecDispatcher getSecDispatcher() {
        if (this.securityDispatcher instanceof DefaultSecDispatcher) {
            ((DefaultSecDispatcher)this.securityDispatcher).setConfigurationFile(this.getHelmSecurity());
        }
        return this.securityDispatcher;
    }

    protected String formatIfValueIsNotEmpty(String format, String value) {
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            return String.format(format, value);
        }
        return "";
    }

    public String getHelmVersion() throws MojoExecutionException {
        if (this.helmVersion == null) {
            this.helmVersion = new Github(this.getLog(), Paths.get(this.tmpDir, new String[0]), this.githubUserAgent).getHelmVersion();
        }
        return this.helmVersion;
    }

    public String getChartVersionWithProcessing() {
        if (this.isTimestampOnSnapshot() && this.chartVersion.endsWith("-SNAPSHOT")) {
            return this.chartVersion.replace("SNAPSHOT", this.getCurrentTimestamp());
        }
        return this.chartVersion;
    }

    private void warnOnMixOfK8sClusterAndGlobalFlags() {
        if (this.k8sCluster == null) {
            return;
        }
        StringBuilder warnMessage = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)this.k8sCluster.getApiUrl()) && StringUtils.isNotEmpty((CharSequence)this.kubeApiServer)) {
            warnMessage.append("Both <kubeApiServer> and <k8sCluster><apiUrl/></k8sCluster> are set.\n");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.k8sCluster.getNamespace()) && StringUtils.isNotEmpty((CharSequence)this.namespace)) {
            warnMessage.append("Both <namespace> and <k8sCluster><namespace/></k8sCluster> are set.\n");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.k8sCluster.getAsUser()) && StringUtils.isNotEmpty((CharSequence)this.kubeAsUser)) {
            warnMessage.append("Both <kubeAsUser> and <k8sCluster><asUser/></k8sCluster> are set.\n");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.k8sCluster.getAsGroup()) && StringUtils.isNotEmpty((CharSequence)this.kubeAsGroup)) {
            warnMessage.append("Both <kubeAsGroup> and <k8sCluster><asGroup/></k8sCluster> are set.\n");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.k8sCluster.getToken()) && StringUtils.isNotEmpty((CharSequence)this.kubeToken)) {
            warnMessage.append("Both <kubeToken> and <k8sCluster><token/></k8sCluster> are set.\n");
        }
        if (warnMessage.length() > 0) {
            warnMessage.append("As per current implementation - <k8sCluster><*></k8sCluster> options win.\n");
            warnMessage.append("NOTE: <k8sCluster> option will be removed in future major release.");
            this.getLog().warn((CharSequence)warnMessage.toString());
        }
    }

    public SecDispatcher getSecurityDispatcher() {
        return this.securityDispatcher;
    }

    public boolean isUseLocalHelmBinary() {
        return this.useLocalHelmBinary;
    }

    public boolean isAutoDetectLocalHelmBinary() {
        return this.autoDetectLocalHelmBinary;
    }

    public String getHelmExecutableDirectory() {
        return this.helmExecutableDirectory;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public String[] getExcludes() {
        return this.excludes;
    }

    public String getChartDirectory() {
        return this.chartDirectory;
    }

    public String getChartVersion() {
        return this.chartVersion;
    }

    public boolean isTimestampOnSnapshot() {
        return this.timestampOnSnapshot;
    }

    public String getTimestampFormat() {
        return this.timestampFormat;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public HelmRepository getUploadRepoStable() {
        return this.uploadRepoStable;
    }

    public HelmRepository getUploadRepoSnapshot() {
        return this.uploadRepoSnapshot;
    }

    public String getHelmDownloadUrl() {
        return this.helmDownloadUrl;
    }

    public String getGithubUserAgent() {
        return this.githubUserAgent;
    }

    public String getTmpDir() {
        return this.tmpDir;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public String getRegistryConfig() {
        return this.registryConfig;
    }

    public String getRepositoryCache() {
        return this.repositoryCache;
    }

    public String getRepositoryConfig() {
        return this.repositoryConfig;
    }

    public HelmRepository[] getHelmExtraRepos() {
        return this.helmExtraRepos;
    }

    public String getHelmSecurity() {
        return this.helmSecurity;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public K8SCluster getK8sCluster() {
        return this.k8sCluster;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public String getProjectGroupId() {
        return this.projectGroupId;
    }

    public String getProjectVersion() {
        return this.projectVersion;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getKubeApiServer() {
        return this.kubeApiServer;
    }

    public String getKubeAsUser() {
        return this.kubeAsUser;
    }

    public String getKubeAsGroup() {
        return this.kubeAsGroup;
    }

    public String getKubeToken() {
        return this.kubeToken;
    }

    public String getKubeCaFile() {
        return this.kubeCaFile;
    }

    public Clock getClock() {
        return this.clock;
    }

    public AbstractHelmMojo setSecurityDispatcher(SecDispatcher securityDispatcher) {
        this.securityDispatcher = securityDispatcher;
        return this;
    }

    public AbstractHelmMojo setUseLocalHelmBinary(boolean useLocalHelmBinary) {
        this.useLocalHelmBinary = useLocalHelmBinary;
        return this;
    }

    public AbstractHelmMojo setAutoDetectLocalHelmBinary(boolean autoDetectLocalHelmBinary) {
        this.autoDetectLocalHelmBinary = autoDetectLocalHelmBinary;
        return this;
    }

    public AbstractHelmMojo setHelmExecutableDirectory(String helmExecutableDirectory) {
        this.helmExecutableDirectory = helmExecutableDirectory;
        return this;
    }

    public AbstractHelmMojo setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
        return this;
    }

    public AbstractHelmMojo setExcludes(String[] excludes) {
        this.excludes = excludes;
        return this;
    }

    public AbstractHelmMojo setChartDirectory(String chartDirectory) {
        this.chartDirectory = chartDirectory;
        return this;
    }

    public AbstractHelmMojo setChartVersion(String chartVersion) {
        this.chartVersion = chartVersion;
        return this;
    }

    public AbstractHelmMojo setTimestampOnSnapshot(boolean timestampOnSnapshot) {
        this.timestampOnSnapshot = timestampOnSnapshot;
        return this;
    }

    public AbstractHelmMojo setTimestampFormat(String timestampFormat) {
        this.timestampFormat = timestampFormat;
        return this;
    }

    public AbstractHelmMojo setAppVersion(String appVersion) {
        this.appVersion = appVersion;
        return this;
    }

    public AbstractHelmMojo setUploadRepoStable(HelmRepository uploadRepoStable) {
        this.uploadRepoStable = uploadRepoStable;
        return this;
    }

    public AbstractHelmMojo setUploadRepoSnapshot(HelmRepository uploadRepoSnapshot) {
        this.uploadRepoSnapshot = uploadRepoSnapshot;
        return this;
    }

    public AbstractHelmMojo setHelmDownloadUrl(String helmDownloadUrl) {
        this.helmDownloadUrl = helmDownloadUrl;
        return this;
    }

    public AbstractHelmMojo setHelmVersion(String helmVersion) {
        this.helmVersion = helmVersion;
        return this;
    }

    public AbstractHelmMojo setGithubUserAgent(String githubUserAgent) {
        this.githubUserAgent = githubUserAgent;
        return this;
    }

    public AbstractHelmMojo setTmpDir(String tmpDir) {
        this.tmpDir = tmpDir;
        return this;
    }

    public AbstractHelmMojo setDebug(boolean debug) {
        this.debug = debug;
        return this;
    }

    public AbstractHelmMojo setRegistryConfig(String registryConfig) {
        this.registryConfig = registryConfig;
        return this;
    }

    public AbstractHelmMojo setRepositoryCache(String repositoryCache) {
        this.repositoryCache = repositoryCache;
        return this;
    }

    public AbstractHelmMojo setRepositoryConfig(String repositoryConfig) {
        this.repositoryConfig = repositoryConfig;
        return this;
    }

    public AbstractHelmMojo setHelmExtraRepos(HelmRepository[] helmExtraRepos) {
        this.helmExtraRepos = helmExtraRepos;
        return this;
    }

    public AbstractHelmMojo setHelmSecurity(String helmSecurity) {
        this.helmSecurity = helmSecurity;
        return this;
    }

    public AbstractHelmMojo setSkip(boolean skip) {
        this.skip = skip;
        return this;
    }

    public AbstractHelmMojo setK8sCluster(K8SCluster k8sCluster) {
        this.k8sCluster = k8sCluster;
        return this;
    }

    public AbstractHelmMojo setSettings(Settings settings) {
        this.settings = settings;
        return this;
    }

    public AbstractHelmMojo setProjectGroupId(String projectGroupId) {
        this.projectGroupId = projectGroupId;
        return this;
    }

    public AbstractHelmMojo setProjectVersion(String projectVersion) {
        this.projectVersion = projectVersion;
        return this;
    }

    public AbstractHelmMojo setNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public AbstractHelmMojo setKubeApiServer(String kubeApiServer) {
        this.kubeApiServer = kubeApiServer;
        return this;
    }

    public AbstractHelmMojo setKubeAsUser(String kubeAsUser) {
        this.kubeAsUser = kubeAsUser;
        return this;
    }

    public AbstractHelmMojo setKubeAsGroup(String kubeAsGroup) {
        this.kubeAsGroup = kubeAsGroup;
        return this;
    }

    public AbstractHelmMojo setKubeToken(String kubeToken) {
        this.kubeToken = kubeToken;
        return this;
    }

    public AbstractHelmMojo setKubeCaFile(String kubeCaFile) {
        this.kubeCaFile = kubeCaFile;
        return this;
    }

    public AbstractHelmMojo setClock(Clock clock) {
        this.clock = clock;
        return this;
    }
}

