/*
 * Decompiled with CFR 0.152.
 */
package io.kokuwa.maven.helm;

import io.kokuwa.maven.helm.AbstractHelmMojo;
import io.kokuwa.maven.helm.pojo.ValueOverride;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractHelmWithValueOverrideMojo
extends AbstractHelmMojo {
    @Parameter(property="helm.values")
    private ValueOverride values;

    protected String getValuesOptions() {
        StringBuilder setValuesOptions = new StringBuilder();
        if (this.values != null) {
            if (AbstractHelmWithValueOverrideMojo.isNotEmpty(this.values.getOverrides())) {
                setValuesOptions.append(" --set ");
                this.appendOverrideMap(setValuesOptions, this.values.getOverrides());
            }
            if (AbstractHelmWithValueOverrideMojo.isNotEmpty(this.values.getStringOverrides())) {
                setValuesOptions.append(" --set-string ");
                this.appendOverrideMap(setValuesOptions, this.values.getStringOverrides());
            }
            if (AbstractHelmWithValueOverrideMojo.isNotEmpty(this.values.getFileOverrides())) {
                setValuesOptions.append(" --set-file ");
                this.appendOverrideMap(setValuesOptions, this.values.getFileOverrides());
            }
            if (StringUtils.isNotBlank((CharSequence)this.values.getYamlFile())) {
                setValuesOptions.append(" --values ").append(this.values.getYamlFile());
            }
            if (this.values.getYamlFiles() != null) {
                for (String yamlFile : this.values.getYamlFiles()) {
                    if (!StringUtils.isNotBlank((CharSequence)yamlFile)) continue;
                    setValuesOptions.append(" --values ").append(yamlFile);
                }
            }
        }
        return setValuesOptions.toString();
    }

    private void appendOverrideMap(StringBuilder setValues, Map<String, String> overrides) {
        boolean first = true;
        for (Map.Entry<String, String> valueEntry : overrides.entrySet()) {
            if (first) {
                first = false;
            } else {
                setValues.append(',');
            }
            setValues.append(valueEntry.getKey()).append('=').append(valueEntry.getValue());
        }
    }

    private static <K, V> boolean isNotEmpty(Map<K, V> map) {
        return map != null && !map.isEmpty();
    }

    public AbstractHelmWithValueOverrideMojo setValues(ValueOverride values) {
        this.values = values;
        return this;
    }
}

