/*
 * Decompiled with CFR 0.152.
 */
package io.kokuwa.maven.helm;

import io.kokuwa.maven.helm.AbstractHelmMojo;
import io.kokuwa.maven.helm.pojo.HelmRepository;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Base64;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="upload", defaultPhase=LifecyclePhase.DEPLOY, threadSafe=true)
public class UploadMojo
extends AbstractHelmMojo {
    @Parameter(property="helm.upload.skip", defaultValue="false")
    private boolean skipUpload;
    @Parameter(defaultValue="${project.groupId}", readonly=true)
    private String projectGroupId;
    @Parameter(defaultValue="${project.version}", readonly=true)
    private String projectVersion;

    public void execute() throws MojoExecutionException {
        if (this.skip || this.skipUpload) {
            this.getLog().info((CharSequence)"Skip upload");
            return;
        }
        this.getLog().info((CharSequence)("Uploading to " + this.getHelmUploadUrl() + "\n"));
        for (Path chart : this.getChartArchives()) {
            this.getLog().info((CharSequence)("Uploading " + chart + "..."));
            try {
                this.uploadSingle(chart);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Upload failed.", (Exception)e);
            }
        }
    }

    private String getHelmUploadUrl() {
        String chartVersion = this.getChartVersion();
        HelmRepository uploadRepoStable = this.getUploadRepoStable();
        HelmRepository uploadRepoSnapshot = this.getUploadRepoSnapshot();
        String uploadUrl = uploadRepoStable.getUrl();
        if (chartVersion != null && chartVersion.endsWith("-SNAPSHOT") && uploadRepoSnapshot != null && StringUtils.isNotEmpty((String)uploadRepoSnapshot.getUrl())) {
            uploadUrl = uploadRepoSnapshot.getUrl();
        }
        return uploadUrl;
    }

    private void uploadSingle(Path chart) throws MojoExecutionException, IOException {
        HttpURLConnection connection;
        File fileToUpload = chart.toFile();
        HelmRepository uploadRepo = this.getHelmUploadRepo();
        if (uploadRepo.getType() == null) {
            throw new IllegalArgumentException("Repository type missing. Check your plugin configuration.");
        }
        switch (uploadRepo.getType()) {
            case ARTIFACTORY: {
                connection = this.getConnectionForUploadToArtifactory(fileToUpload, uploadRepo.isUseGroupId());
                break;
            }
            case CHARTMUSEUM: {
                connection = this.getConnectionForUploadToChartmuseum();
                break;
            }
            case NEXUS: {
                connection = this.getConnectionForUploadToNexus(fileToUpload);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported repository type for upload.");
            }
        }
        try (FileInputStream fileInputStream = new FileInputStream(fileToUpload);){
            IOUtils.copy((InputStream)fileInputStream, (OutputStream)connection.getOutputStream());
        }
        if (connection.getResponseCode() >= 300) {
            String response = connection.getErrorStream() != null ? new String(IOUtils.toByteArray((InputStream)connection.getErrorStream())) : (connection.getInputStream() != null ? new String(IOUtils.toByteArray((InputStream)connection.getInputStream())) : "No details provided");
            throw new MojoExecutionException("Failed to upload: " + response);
        }
        String message = Integer.toString(connection.getResponseCode());
        if (connection.getInputStream() != null) {
            message = message + " - " + new String(IOUtils.toByteArray((InputStream)connection.getInputStream()));
        }
        this.getLog().info((CharSequence)message);
        connection.disconnect();
    }

    private HttpURLConnection getConnectionForUploadToChartmuseum() throws IOException, MojoExecutionException {
        HttpURLConnection connection = (HttpURLConnection)new URL(this.getHelmUploadUrl()).openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/gzip");
        this.setBasicAuthHeader(connection);
        return connection;
    }

    private void setBasicAuthHeader(HttpURLConnection connection) throws MojoExecutionException {
        PasswordAuthentication authentication = this.getAuthentication(this.getHelmUploadRepo());
        if (authentication != null) {
            String encoded = Base64.getEncoder().encodeToString((authentication.getUserName() + ":" + new String(authentication.getPassword())).getBytes(StandardCharsets.UTF_8));
            connection.setRequestProperty("Authorization", "Basic " + encoded);
        }
    }

    private HttpURLConnection getConnectionForUploadToArtifactory(File file, boolean useGroupId) throws IOException, MojoExecutionException {
        String uploadUrl = this.getHelmUploadUrl();
        if (!uploadUrl.endsWith("/")) {
            uploadUrl = uploadUrl + "/";
        }
        if (useGroupId) {
            uploadUrl = uploadUrl + this.projectGroupId.replace(".", "/") + "/" + this.projectVersion + "/";
        }
        uploadUrl = uploadUrl + file.getName();
        HttpURLConnection connection = (HttpURLConnection)new URL(uploadUrl).openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("PUT");
        connection.setRequestProperty("Content-Type", "application/gzip");
        this.verifyAndSetAuthentication(true);
        return connection;
    }

    private HttpURLConnection getConnectionForUploadToNexus(File file) throws IOException, MojoExecutionException {
        String uploadUrl = this.getHelmUploadUrl();
        if (!uploadUrl.endsWith("/")) {
            uploadUrl = uploadUrl + "/";
        }
        uploadUrl = uploadUrl + file.getName();
        HttpURLConnection connection = (HttpURLConnection)new URL(uploadUrl).openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("PUT");
        connection.setRequestProperty("Content-Type", "application/gzip");
        this.verifyAndSetAuthentication(false);
        return connection;
    }

    private void verifyAndSetAuthentication(boolean requireCredentials) throws MojoExecutionException {
        final PasswordAuthentication authentication = this.getAuthentication(this.getHelmUploadRepo());
        if (authentication != null) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return authentication;
                }
            });
        } else if (requireCredentials) {
            throw new IllegalArgumentException("Credentials has to be configured for uploading to Artifactory.");
        }
    }

    public UploadMojo setSkipUpload(boolean skipUpload) {
        this.skipUpload = skipUpload;
        return this;
    }

    public UploadMojo setProjectGroupId(String projectGroupId) {
        this.projectGroupId = projectGroupId;
        return this;
    }

    public UploadMojo setProjectVersion(String projectVersion) {
        this.projectVersion = projectVersion;
        return this;
    }
}

