/*
 * Decompiled with CFR 0.152.
 */
package io.kokuwa.maven.helm.pojo;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.StringUtils;

public class HelmExecutable {
    private final Log log;
    private final Path executable;
    private final List<String> arguments = new ArrayList<String>();
    private final Set<String> sensitiveFlags = new HashSet<String>(Arrays.asList("password", "kube-token"));
    private final Map<String, List<String>> flags = new LinkedHashMap<String, List<String>>();
    private String stdin;

    public HelmExecutable arguments(Object ... args) {
        Stream.of(args).filter(Objects::nonNull).map(Object::toString).forEach(this.arguments::add);
        return this;
    }

    public HelmExecutable flag(String key) {
        return this.flag(key, true);
    }

    public HelmExecutable flag(String key, boolean value) {
        if (value) {
            this.flags.put(key, Arrays.asList(new String[0]));
        }
        return this;
    }

    public HelmExecutable flag(String key, File file) {
        if (file != null) {
            this.flag(key, file.toPath());
        }
        return this;
    }

    public HelmExecutable flag(String key, Path path) {
        if (path != null) {
            this.flags.computeIfAbsent(key, k -> new ArrayList()).add(path.toString());
        }
        return this;
    }

    public HelmExecutable flag(String key, String value) {
        if (StringUtils.isNotBlank((String)value)) {
            this.flags.computeIfAbsent(key, k -> new ArrayList()).add(value);
        }
        return this;
    }

    public void execute(String errorMessage) throws MojoExecutionException {
        String command = Stream.of(this.toCommand(true)).collect(Collectors.joining(" "));
        this.log.debug((CharSequence)("Execute: " + command));
        try {
            Process process = Runtime.getRuntime().exec(this.toCommand(false));
            if (StringUtils.isNotEmpty((String)this.stdin)) {
                try (OutputStream output = process.getOutputStream();){
                    output.write(this.stdin.getBytes(StandardCharsets.UTF_8));
                }
                catch (IOException e) {
                    this.log.error((CharSequence)"failed to write to stdin of helm", (Throwable)e);
                }
            }
            new Thread(() -> {
                try (InputStream input = process.getInputStream();){
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(input));
                    while ((line = reader.readLine()) != null) {
                        this.log.info((CharSequence)line);
                    }
                }
                catch (IOException e) {
                    this.log.error((CharSequence)"Failed to redirect input", (Throwable)e);
                }
            }).start();
            new Thread(() -> {
                try (InputStream error = process.getErrorStream();){
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(error));
                    while ((line = reader.readLine()) != null) {
                        this.log.error((CharSequence)line);
                    }
                }
                catch (IOException e) {
                    this.log.error((CharSequence)"Failed to redirect errors", (Throwable)e);
                }
            }).start();
            if (process.waitFor() != 0) {
                throw new MojoExecutionException(errorMessage);
            }
        }
        catch (IOException | InterruptedException e) {
            throw new MojoExecutionException("Error processing command: " + command, e);
        }
    }

    private String[] toCommand(boolean stripSensitiveFlags) {
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.executable.toString());
        command.addAll(this.arguments);
        for (Map.Entry<String, List<String>> entry : this.flags.entrySet()) {
            String flag = entry.getKey();
            List<String> values = entry.getValue();
            if (values.isEmpty()) {
                command.add("--" + flag);
            }
            for (String value : values) {
                command.add("--" + flag);
                command.add(stripSensitiveFlags && this.sensitiveFlags.contains(flag) ? "********" : value);
            }
        }
        return command.toArray(new String[command.size()]);
    }

    public HelmExecutable(Log log, Path executable) {
        this.log = log;
        this.executable = executable;
    }

    public Path getExecutable() {
        return this.executable;
    }

    public HelmExecutable setStdin(String stdin) {
        this.stdin = stdin;
        return this;
    }
}

