/*
 * Decompiled with CFR 0.152.
 */
package io.kokuwa.maven.helm;

import io.kokuwa.maven.helm.AbstractHelmMojo;
import io.kokuwa.maven.helm.pojo.HelmRepository;
import java.io.File;
import java.net.PasswordAuthentication;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="registry-login", defaultPhase=LifecyclePhase.INITIALIZE, threadSafe=true)
public class RegistryLoginMojo
extends AbstractHelmMojo {
    @Parameter(property="helm.registry-login.caFile")
    private File caFile;
    @Parameter(property="helm.registry-login.insecure", defaultValue="false")
    private boolean insecure;
    @Parameter(property="helm.registry-login.skip", defaultValue="false")
    private boolean skipRegistryLogin;

    public void execute() throws MojoExecutionException {
        if (this.skip || this.skipRegistryLogin) {
            this.getLog().info((CharSequence)"Skip registry login");
            return;
        }
        HelmRepository repository = this.getHelmUploadRepo();
        if (repository == null) {
            this.getLog().warn((CharSequence)"No upload repo found for login, skipped.");
            return;
        }
        PasswordAuthentication authentication = this.getAuthentication(repository);
        if (authentication == null) {
            this.getLog().warn((CharSequence)"No credentials found for upload repo.");
            return;
        }
        this.helm().arguments("registry", "login", repository.getUrl()).flag("ca-file", this.caFile).flag("insecure", this.insecure).flag("username", authentication.getUserName()).flag("password-stdin").setStdin(new String(authentication.getPassword())).execute("Failed to login into repository " + repository.getName() + " at " + repository.getUrl());
    }

    public RegistryLoginMojo setCaFile(File caFile) {
        this.caFile = caFile;
        return this;
    }

    public RegistryLoginMojo setInsecure(boolean insecure) {
        this.insecure = insecure;
        return this;
    }

    public RegistryLoginMojo setSkipRegistryLogin(boolean skipRegistryLogin) {
        this.skipRegistryLogin = skipRegistryLogin;
        return this;
    }
}

