/*
 * Decompiled with CFR 0.152.
 */
package io.kokuwa.maven.helm;

import io.kokuwa.maven.helm.AbstractHelmWithValueOverrideMojo;
import java.io.File;
import java.nio.file.Path;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="template", defaultPhase=LifecyclePhase.TEST, threadSafe=true)
public class TemplateMojo
extends AbstractHelmWithValueOverrideMojo {
    @Deprecated
    @Parameter(property="action", defaultValue="template")
    private String action;
    @Parameter(property="helm.template.output-dir")
    private File templateOutputDir;
    @Parameter(property="helm.template.generate-name", defaultValue="false")
    private boolean templateGenerateName;
    @Deprecated
    @Parameter(property="helm.additional.arguments")
    private String additionalArguments;
    @Parameter(property="helm.template.skip", defaultValue="true")
    private boolean skipTemplate;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip || this.skipTemplate) {
            this.getLog().info((CharSequence)"Skip template");
            return;
        }
        for (Path chartDirectory : this.getChartDirectories()) {
            this.getLog().info((CharSequence)String.format("\n\nPerform template for chart %s...", chartDirectory));
            this.helm().arguments(this.action, chartDirectory).arguments(this.getArguments()).flag("output-dir", this.templateOutputDir).flag("generate-name", this.templateGenerateName).execute("There are test failures");
        }
    }

    private Object[] getArguments() {
        if (StringUtils.isEmpty((String)this.additionalArguments)) {
            return new Object[0];
        }
        this.getLog().warn((CharSequence)"NOTE: <additionalArguments> option will be removed in future major release.");
        return this.additionalArguments.split(" ");
    }

    @Deprecated
    public TemplateMojo setAction(String action) {
        this.action = action;
        return this;
    }

    public TemplateMojo setTemplateOutputDir(File templateOutputDir) {
        this.templateOutputDir = templateOutputDir;
        return this;
    }

    public TemplateMojo setTemplateGenerateName(boolean templateGenerateName) {
        this.templateGenerateName = templateGenerateName;
        return this;
    }

    @Deprecated
    public TemplateMojo setAdditionalArguments(String additionalArguments) {
        this.additionalArguments = additionalArguments;
        return this;
    }

    public TemplateMojo setSkipTemplate(boolean skipTemplate) {
        this.skipTemplate = skipTemplate;
        return this;
    }
}

