/*
 * Decompiled with CFR 0.152.
 */
package io.kokuwa.micronaut.logging.mdc;

import ch.qos.logback.classic.Level;
import io.kokuwa.micronaut.logging.LogbackUtil;
import io.kokuwa.micronaut.logging.mdc.MDCTurboFilter;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Context;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.env.Environment;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Argument;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requirements(value={@Requires(beans={LogbackUtil.class}), @Requires(property="logger.mdc"), @Requires(property="logger.mdc.enabled", notEquals="false")})
@BootstrapContextCompatible
@Context
@Internal
public class MDCTurboFilterConfigurer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MDCTurboFilterConfigurer.class);
    public static final String PREFIX = "logger.mdc";
    private final LogbackUtil logback;
    private final Environment environment;

    public MDCTurboFilterConfigurer(LogbackUtil logback, Environment environment) {
        this.logback = logback;
        this.environment = environment;
        this.configure();
    }

    public void configure() {
        for (String name : this.environment.getPropertyEntries(PREFIX)) {
            String prefix = "logger.mdc." + name + ".";
            String key = (String)this.environment.getProperty(prefix + "key", String.class, (Object)name);
            Set loggers = this.environment.getProperty(prefix + "loggers", Argument.setOf(String.class)).orElseGet(Set::of);
            Set values = this.environment.getProperty(prefix + "values", Argument.setOf(String.class)).orElseGet(Set::of);
            Level level = Level.valueOf((String)((String)this.environment.getProperty(prefix + "level", String.class, (Object)Level.TRACE.toString())));
            this.logback.getTurboFilter(MDCTurboFilter.class, name, MDCTurboFilter::new).setKey(key).setLevel(level).setLoggers(loggers).setValues(values).start();
            log.info("Configured MDC filter {} for key {} with level {}.", new Object[]{name, key, level});
        }
    }
}

