/*
 * Decompiled with CFR 0.152.
 */
package io.kokuwa.micronaut.logging.configurator;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.Configurator;
import ch.qos.logback.classic.util.DefaultJoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.spi.ContextAwareBase;
import io.kokuwa.micronaut.logging.configurator.MicronautJoranConfigurator;
import java.net.URL;

public class DefaultConfigurator
extends ContextAwareBase
implements Configurator {
    public Configurator.ExecutionStatus configure(LoggerContext loggerContext) {
        if (new DefaultJoranConfigurator().findURLOfDefaultConfigurationFile(false) != null) {
            return Configurator.ExecutionStatus.INVOKE_NEXT_IF_ANY;
        }
        URL base = DefaultConfigurator.class.getResource("/io/kokuwa/logback/logback-default.xml");
        if (base == null) {
            this.addError("Failed to find logback.xml from io.kokuwa:micronaut-logging");
            return Configurator.ExecutionStatus.NEUTRAL;
        }
        try {
            this.addInfo("Use logback.xml from io.kokuwa:micronaut-logging");
            MicronautJoranConfigurator configurator = new MicronautJoranConfigurator();
            configurator.setContext((Context)loggerContext);
            configurator.doConfigure(base);
        }
        catch (JoranException e) {
            this.addError("Failed to load logback.xml from io.kokuwa:micronaut-logging", e);
            return Configurator.ExecutionStatus.NEUTRAL;
        }
        return Configurator.ExecutionStatus.DO_NOT_INVOKE_NEXT_IF_ANY;
    }
}

