/*
 * Decompiled with CFR 0.152.
 */
package io.kokuwa.micronaut.logging.configurator;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.encoder.LayoutWrappingEncoder;
import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.spi.SaxEventInterpretationContext;
import io.kokuwa.micronaut.logging.layout.GcpJsonLayout;
import io.kokuwa.micronaut.logging.layout.JsonLayout;
import io.micronaut.core.util.StringUtils;
import java.util.Iterator;
import java.util.Optional;
import org.xml.sax.Attributes;

public class RootAutoSelectAppenderAction
extends Action {
    private static final boolean IS_KUBERNETES = StringUtils.isNotEmpty((CharSequence)System.getenv("KUBERNETES_SERVICE_HOST"));
    private static final boolean IS_GCP = StringUtils.isNotEmpty((CharSequence)System.getenv("GOOGLE_CLOUD_PROJECT"));
    private static final String APPENDER_CONSOLE = "CONSOLE";
    private static final String APPENDER_JSON = "JSON";
    private static final String APPENDER_GCP = "GCP";
    private static final String LOGBACK_APPENDER = "LOGBACK_APPENDER";
    private static final String LOGBACK_PATTERN = "LOGBACK_PATTERN";
    private static final String LOGBACK_PATTERN_DEFAULT = "%cyan(%d{HH:mm:ss.SSS}) %gray(%-6.6thread) %highlight(%-5level) %magenta(%32logger{32}) %mdc %msg%n";

    public void begin(SaxEventInterpretationContext ic, String name, Attributes attributes) {
        Logger rootLogger = ((LoggerContext)LoggerContext.class.cast(this.context)).getLogger("ROOT");
        Iterator rootLoggerAppenders = rootLogger.iteratorForAppenders();
        if (rootLoggerAppenders.hasNext()) {
            this.addWarn("Skip because appender already found: " + ((Appender)rootLoggerAppenders.next()).getName());
            return;
        }
        String envAppender = this.env(LOGBACK_APPENDER, null);
        if (envAppender != null) {
            this.setAppender(rootLogger, envAppender);
            return;
        }
        if (IS_KUBERNETES) {
            this.setAppender(rootLogger, APPENDER_JSON);
            return;
        }
        if (IS_GCP) {
            this.setAppender(rootLogger, APPENDER_GCP);
            return;
        }
        this.setAppender(rootLogger, APPENDER_CONSOLE);
    }

    public void end(SaxEventInterpretationContext ic, String name) {
    }

    private void setAppender(Logger rootLogger, String appenderName) {
        this.addInfo("Use appender: " + appenderName);
        Layout<ILoggingEvent> layout = switch (appenderName) {
            case APPENDER_JSON -> this.json();
            case APPENDER_GCP -> this.gcp();
            case APPENDER_CONSOLE -> this.console();
            default -> {
                this.addError("Appender " + appenderName + " not found. Using console ...");
                yield this.console();
            }
        };
        layout.start();
        LayoutWrappingEncoder encoder = new LayoutWrappingEncoder();
        encoder.setContext(this.context);
        encoder.setLayout(layout);
        encoder.start();
        ConsoleAppender appender = new ConsoleAppender();
        appender.setContext(this.context);
        appender.setName(appenderName);
        appender.setEncoder((Encoder)encoder);
        appender.start();
        rootLogger.addAppender((Appender)appender);
    }

    private Layout<ILoggingEvent> console() {
        PatternLayout layout = new PatternLayout();
        layout.setContext(this.context);
        layout.setPattern(this.env(LOGBACK_PATTERN, LOGBACK_PATTERN_DEFAULT));
        return layout;
    }

    private Layout<ILoggingEvent> json() {
        JsonLayout layout = new JsonLayout();
        layout.setContext(this.context);
        return layout;
    }

    private Layout<ILoggingEvent> gcp() {
        GcpJsonLayout layout = new GcpJsonLayout();
        layout.setContext(this.context);
        layout.setServiceName(this.env("SERVICE_NAME", null));
        layout.setServiceVersion(this.env("SERVICE_VERSION", null));
        return layout;
    }

    private String env(String name, String defaultValue) {
        Optional<String> envValue = Optional.ofNullable(System.getenv(name)).map(String::trim).filter(StringUtils::isNotEmpty);
        String finalValue = envValue.orElse(defaultValue);
        if (envValue.isPresent()) {
            this.addInfo("Use provided config: " + name + "=" + finalValue);
        } else {
            this.addInfo("Use default config: " + name + "=" + finalValue);
        }
        return finalValue;
    }
}

