/*
 * Decompiled with CFR 0.152.
 */
package io.kokuwa.micronaut.logging.http.level;

import io.kokuwa.micronaut.logging.http.level.LogLevelServerFilter;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.annotation.Value;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.context.ServerRequestContext;
import io.micronaut.http.filter.ClientFilterChain;
import io.micronaut.http.filter.HttpClientFilter;
import java.util.Optional;
import org.reactivestreams.Publisher;

@Requirements(value={@Requires(beans={LogLevelServerFilter.class}), @Requires(property="logger.http.level.propagation.enabled", notEquals="false")})
@Filter(value={"${logger.http.level.propagation.path:/**}"})
public class LogLevelClientFilter
implements HttpClientFilter {
    public static final String PREFIX = "logger.http.level.propagation";
    public static final int DEFAULT_ORDER = Integer.MIN_VALUE;
    private final String serverHeader;
    private final String propagationHeader;
    private final int order;

    public LogLevelClientFilter(@Value(value="${logger.http.level.header}") Optional<String> serverHeader, @Value(value="${logger.http.level.propagation.header}") Optional<String> propagationHeader, @Value(value="${logger.http.level.propagation.order}") Optional<Integer> order) {
        this.serverHeader = serverHeader.orElse("x-log-level");
        this.propagationHeader = propagationHeader.orElse(this.serverHeader);
        this.order = order.orElse(Integer.MIN_VALUE);
    }

    public int getOrder() {
        return this.order;
    }

    public Publisher<? extends HttpResponse<?>> doFilter(MutableHttpRequest<?> targetRequest, ClientFilterChain chain) {
        ServerRequestContext.currentRequest().flatMap(currentRequest -> currentRequest.getHeaders().getFirst((CharSequence)this.serverHeader)).ifPresent(level -> targetRequest.getHeaders().add((CharSequence)this.propagationHeader, (CharSequence)level));
        return chain.proceed(targetRequest);
    }
}

