/*
 * Decompiled with CFR 0.152.
 */
package io.kokuwa.micronaut.logging.http.level;

import ch.qos.logback.classic.turbo.TurboFilter;
import io.kokuwa.micronaut.logging.LogbackUtil;
import io.kokuwa.micronaut.logging.http.AbstractMdcFilter;
import io.kokuwa.micronaut.logging.http.level.LogLevelTurboFilter;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.annotation.Value;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.filter.ServerFilterChain;
import io.micronaut.http.filter.ServerFilterPhase;
import io.micronaut.runtime.context.scope.Refreshable;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.Map;
import java.util.Optional;
import org.reactivestreams.Publisher;

@Refreshable
@Requires(property="logger.http.level.enabled", notEquals="false")
@Filter(value={"${logger.http.level.path:/**}"})
public class LogLevelServerFilter
extends AbstractMdcFilter {
    public static final String PREFIX = "logger.http.level";
    public static final String DEFAULT_HEADER = "x-log-level";
    public static final int DEFAULT_ORDER = ServerFilterPhase.FIRST.before();
    public static final String MDC_KEY = "level";
    public static final String MDC_FILTER = "logger.http.level";
    private final LogbackUtil logback;
    private final String header;

    public LogLevelServerFilter(LogbackUtil logback, @Value(value="${logger.http.level.header}") Optional<String> header, @Value(value="${logger.http.level.order}") Optional<Integer> order) {
        super(order.orElse(DEFAULT_ORDER), null);
        this.logback = logback;
        this.header = header.orElse(DEFAULT_HEADER);
    }

    @PostConstruct
    void startTurbofilter() {
        this.logback.getTurboFilter(LogLevelTurboFilter.class, "logger.http.level", LogLevelTurboFilter::new).start();
    }

    @PreDestroy
    void stopTurbofilter() {
        this.logback.getTurboFilter(LogLevelTurboFilter.class, "logger.http.level").ifPresent(TurboFilter::stop);
    }

    public Publisher<MutableHttpResponse<?>> doFilter(HttpRequest<?> request, ServerFilterChain chain) {
        return request.getHeaders().getFirst((CharSequence)this.header).map(level -> this.doFilter(request, chain, Map.of(MDC_KEY, level))).orElseGet(() -> chain.proceed(request));
    }
}

