/*
 * Decompiled with CFR 0.152.
 */
package io.kokuwa.micronaut.logging.http.mdc;

import io.kokuwa.micronaut.logging.http.AbstractMdcFilter;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.annotation.Value;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.filter.ServerFilterChain;
import io.micronaut.http.filter.ServerFilterPhase;
import io.micronaut.runtime.context.scope.Refreshable;
import io.micronaut.security.authentication.Authentication;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.reactivestreams.Publisher;

@Refreshable
@Requirements(value={@Requires(classes={Authentication.class}), @Requires(property="logger.http.authentication.enabled", notEquals="false")})
@Filter(value={"${logger.http.authentication.path:/**}"})
public class AuthenticationMdcFilter
extends AbstractMdcFilter {
    public static final String PREFIX = "logger.http.authentication";
    public static final String DEFAULT_NAME = "principal";
    public static final int DEFAULT_ORDER = ServerFilterPhase.SECURITY.after();
    private final String name;
    private final Set<String> attributes;

    public AuthenticationMdcFilter(@Value(value="${logger.http.authentication.name}") Optional<String> name, @Value(value="${logger.http.authentication.attributes}") Optional<Set<String>> attributes, @Value(value="${logger.http.authentication.prefix}") Optional<String> prefix, @Value(value="${logger.http.authentication.order}") Optional<Integer> order) {
        super(order.orElse(DEFAULT_ORDER), prefix.orElse(null));
        this.name = name.orElse(DEFAULT_NAME);
        this.attributes = attributes.orElseGet(Set::of);
        if (name.isPresent() || !this.attributes.isEmpty()) {
            this.log.info("Configured with name {} and attributes {}", (Object)this.name, this.attributes);
        }
    }

    public Publisher<MutableHttpResponse<?>> doFilter(HttpRequest<?> request, ServerFilterChain chain) {
        Optional authenticationOptional = request.getUserPrincipal(Authentication.class);
        if (authenticationOptional.isEmpty()) {
            return chain.proceed(request);
        }
        Authentication authentication = (Authentication)authenticationOptional.get();
        Map authenticationAttributes = authentication.getAttributes();
        HashMap<String, String> mdc = new HashMap<String, String>();
        mdc.put(this.name, authentication.getName());
        for (String attibuteName : this.attributes) {
            Object attibuteValue = authenticationAttributes.get(attibuteName);
            if (attibuteValue == null) continue;
            mdc.put(attibuteName, String.valueOf(attibuteValue));
        }
        return this.doFilter(request, chain, mdc);
    }
}

