/*
 * Decompiled with CFR 0.152.
 */
package io.kokuwa.micronaut.logging.http.mdc;

import io.kokuwa.micronaut.logging.http.AbstractMdcFilter;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.annotation.Value;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.filter.ServerFilterChain;
import io.micronaut.http.filter.ServerFilterPhase;
import io.micronaut.runtime.context.scope.Refreshable;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.reactivestreams.Publisher;

@Refreshable
@Requirements(value={@Requires(property="logger.http.header.enabled", notEquals="false"), @Requires(property="logger.http.header.names")})
@Filter(value={"${logger.http.header.path:/**}"})
public class HeaderMdcFilter
extends AbstractMdcFilter {
    public static final String PREFIX = "logger.http.header";
    public static final int DEFAULT_ORDER = ServerFilterPhase.FIRST.before();
    private final List<String> headers;

    public HeaderMdcFilter(@Value(value="${logger.http.header.names}") List<String> headers, @Value(value="${logger.http.header.prefix}") Optional<String> prefix, @Value(value="${logger.http.header.order}") Optional<Integer> order) {
        super(order.orElse(DEFAULT_ORDER), prefix.orElse(null));
        this.headers = headers.stream().map(String::toLowerCase).toList();
        this.log.info("Configured with header names {}", headers);
    }

    public Publisher<MutableHttpResponse<?>> doFilter(HttpRequest<?> request, ServerFilterChain chain) {
        HashMap<String, String> mdc = new HashMap<String, String>();
        for (String header : this.headers) {
            request.getHeaders().getFirst((CharSequence)header).ifPresent(value -> mdc.put(header, String.valueOf(value)));
        }
        return this.doFilter(request, chain, mdc);
    }
}

