/*
 * Decompiled with CFR 0.152.
 */
package io.kokuwa.micronaut.logging.http.mdc;

import io.kokuwa.micronaut.logging.http.AbstractMdcFilter;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.annotation.Value;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.filter.ServerFilterChain;
import io.micronaut.http.filter.ServerFilterPhase;
import io.micronaut.runtime.context.scope.Refreshable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.reactivestreams.Publisher;

@Refreshable
@Requirements(value={@Requires(property="logger.http.path.enabled", notEquals="false"), @Requires(property="logger.http.path.patterns")})
@Filter(value={"${logger.http.path.path:/**}"})
public class PathMdcFilter
extends AbstractMdcFilter {
    public static final String PREFIX = "logger.http.path";
    public static final int DEFAULT_ORDER = ServerFilterPhase.FIRST.before();
    public static final Pattern PATTERN_GROUPS = Pattern.compile("\\(\\?<([a-zA-Z][a-zA-Z0-9]+)>");
    private final Map<Pattern, Set<String>> patternsWithGroups = new HashMap<Pattern, Set<String>>();

    public PathMdcFilter(@Value(value="${logger.http.path.patterns}") List<String> patterns, @Value(value="${logger.http.path.prefix}") Optional<String> prefix, @Value(value="${logger.http.path.order}") Optional<Integer> order) {
        super(order.orElse(DEFAULT_ORDER), prefix.orElse(null));
        for (String patternString : patterns) {
            try {
                Pattern pattern = Pattern.compile(patternString);
                Matcher groupMatcher = PATTERN_GROUPS.matcher(pattern.toString());
                HashSet<String> groups = new HashSet<String>();
                while (groupMatcher.find()) {
                    groups.add(groupMatcher.group(1));
                }
                if (groups.isEmpty()) {
                    this.log.warn("Path {} is missing groups.", (Object)patternString);
                    continue;
                }
                this.log.info("Added path {} with groups {}.", (Object)patternString, groups);
                this.patternsWithGroups.put(pattern, groups);
            }
            catch (PatternSyntaxException e) {
                this.log.warn("Path {} is invalid.", (Object)patternString);
            }
        }
    }

    public Publisher<MutableHttpResponse<?>> doFilter(HttpRequest<?> request, ServerFilterChain chain) {
        HashMap<String, String> mdc = new HashMap<String, String>();
        String path = request.getPath();
        for (Map.Entry<Pattern, Set<String>> patternWithGroup : this.patternsWithGroups.entrySet()) {
            Matcher matcher = patternWithGroup.getKey().matcher(path);
            if (!matcher.matches()) continue;
            for (String group : patternWithGroup.getValue()) {
                mdc.put(group, matcher.group(group));
            }
        }
        return this.doFilter(request, chain, mdc);
    }
}

