/*
 * Decompiled with CFR 0.152.
 */
package io.kokuwa.micronaut.logging.layout;

import ch.qos.logback.classic.pattern.ThrowableHandlingConverter;
import ch.qos.logback.classic.pattern.ThrowableProxyConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.LayoutBase;
import ch.qos.logback.core.status.OnConsoleStatusListener;
import ch.qos.logback.core.status.StatusUtil;
import ch.qos.logback.core.util.StatusListenerConfigHelper;
import io.micronaut.json.JsonMapper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimeZone;

public class JsonLayout
extends LayoutBase<ILoggingEvent> {
    public static final String TIMESTAMP_ATTR_NAME = "timestamp";
    public static final String LEVEL_ATTR_NAME = "level";
    public static final String THREAD_ATTR_NAME = "thread";
    public static final String MDC_ATTR_NAME = "mdc";
    public static final String LOGGER_ATTR_NAME = "logger";
    public static final String FORMATTED_MESSAGE_ATTR_NAME = "message";
    public static final String MESSAGE_ATTR_NAME = "raw-message";
    public static final String EXCEPTION_ATTR_NAME = "exception";
    public static final String CONTEXT_ATTR_NAME = "context";
    protected boolean includeLevel = true;
    protected boolean includeThreadName = true;
    protected boolean includeMDC = true;
    protected boolean includeLoggerName = true;
    protected boolean includeFormattedMessage = true;
    protected boolean includeMessage = true;
    protected boolean includeException = true;
    protected boolean includeContextName = false;
    protected boolean includeTimestamp = true;
    private String timestampFormat;
    private String timestampFormatTimezoneId;
    private ThrowableHandlingConverter throwableHandlingConverter = new ThrowableProxyConverter();
    private JsonMapper mapper;

    public String getContentType() {
        return "application/json";
    }

    public void start() {
        this.throwableHandlingConverter.start();
        super.start();
    }

    public void stop() {
        super.stop();
        this.throwableHandlingConverter.stop();
    }

    public String doLayout(ILoggingEvent event) {
        Map<String, Object> map = this.toJsonMap(event);
        if (this.mapper == null) {
            try {
                this.mapper = JsonMapper.createDefault();
            }
            catch (IllegalStateException e) {
                if (!StatusUtil.contextHasStatusListener((Context)this.context)) {
                    this.addError("Failed to get object mapper from micronaut, please check your classpath");
                    StatusListenerConfigHelper.addOnConsoleListenerInstance((Context)this.context, (OnConsoleStatusListener)new OnConsoleStatusListener());
                }
                return map.toString() + CoreConstants.LINE_SEPARATOR;
            }
        }
        try {
            return new String(this.mapper.writeValueAsBytes(map), StandardCharsets.UTF_8) + CoreConstants.LINE_SEPARATOR;
        }
        catch (IOException e) {
            this.addError("Failed to write json from event " + event + " and map " + map, e);
            return null;
        }
    }

    protected Map<String, Object> toJsonMap(ILoggingEvent event) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        this.addTimestamp(TIMESTAMP_ATTR_NAME, this.includeTimestamp, event.getTimeStamp(), map);
        this.add(LEVEL_ATTR_NAME, this.includeLevel, String.valueOf(event.getLevel()), map);
        this.add(THREAD_ATTR_NAME, this.includeThreadName, event.getThreadName(), map);
        this.addMap(MDC_ATTR_NAME, this.includeMDC, event.getMDCPropertyMap(), map);
        this.add(LOGGER_ATTR_NAME, this.includeLoggerName, event.getLoggerName(), map);
        this.add(FORMATTED_MESSAGE_ATTR_NAME, this.includeFormattedMessage, event.getFormattedMessage(), map);
        this.add(MESSAGE_ATTR_NAME, this.includeMessage, event.getMessage(), map);
        this.add(CONTEXT_ATTR_NAME, this.includeContextName, event.getLoggerContextVO().getName(), map);
        this.addThrowableInfo(EXCEPTION_ATTR_NAME, this.includeException, event, map);
        return map;
    }

    protected void addThrowableInfo(String fieldName, boolean field, ILoggingEvent value, Map<String, Object> map) {
        String ex;
        IThrowableProxy throwableProxy;
        if (field && value != null && (throwableProxy = value.getThrowableProxy()) != null && (ex = this.throwableHandlingConverter.convert((Object)value)) != null && !ex.isEmpty()) {
            map.put(fieldName, ex);
        }
    }

    protected void addMap(String key, boolean field, Map<String, ?> mapValue, Map<String, Object> map) {
        if (field && mapValue != null && !mapValue.isEmpty()) {
            map.put(key, mapValue);
        }
    }

    protected void addTimestamp(String key, boolean field, long timeStamp, Map<String, Object> map) {
        String formatted;
        if (field && (formatted = this.formatTimestamp(timeStamp)) != null) {
            map.put(key, formatted);
        }
    }

    protected void add(String fieldName, boolean field, String value, Map<String, Object> map) {
        if (field && value != null) {
            map.put(fieldName, value);
        }
    }

    protected String formatTimestamp(long timestamp) {
        if (this.timestampFormat == null || timestamp < 0L) {
            return String.valueOf(timestamp);
        }
        Date date = new Date(timestamp);
        SimpleDateFormat format = new SimpleDateFormat(this.timestampFormat);
        if (this.timestampFormatTimezoneId != null) {
            format.setTimeZone(TimeZone.getTimeZone(this.timestampFormatTimezoneId));
        }
        return format.format(date);
    }

    public void setIncludeLevel(boolean includeLevel) {
        this.includeLevel = includeLevel;
    }

    public void setIncludeThreadName(boolean includeThreadName) {
        this.includeThreadName = includeThreadName;
    }

    public void setIncludeMDC(boolean includeMDC) {
        this.includeMDC = includeMDC;
    }

    public void setIncludeLoggerName(boolean includeLoggerName) {
        this.includeLoggerName = includeLoggerName;
    }

    public void setIncludeFormattedMessage(boolean includeFormattedMessage) {
        this.includeFormattedMessage = includeFormattedMessage;
    }

    public void setIncludeMessage(boolean includeMessage) {
        this.includeMessage = includeMessage;
    }

    public void setIncludeException(boolean includeException) {
        this.includeException = includeException;
    }

    public void setIncludeContextName(boolean includeContextName) {
        this.includeContextName = includeContextName;
    }

    public void setIncludeTimestamp(boolean includeTimestamp) {
        this.includeTimestamp = includeTimestamp;
    }

    public void setTimestampFormat(String timestampFormat) {
        this.timestampFormat = timestampFormat;
    }

    public void setTimestampFormatTimezoneId(String timestampFormatTimezoneId) {
        this.timestampFormatTimezoneId = timestampFormatTimezoneId;
    }

    public void setThrowableHandlingConverter(ThrowableHandlingConverter throwableHandlingConverter) {
        this.throwableHandlingConverter = throwableHandlingConverter;
    }
}

