/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.micronaut.core.util.CollectionUtils;
import io.micronaut.http.HttpStatus;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.servers.Server;
import java.io.File;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenDiscriminator;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenResponse;
import org.openapitools.codegen.SpecValidationException;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractJavaCodegen;
import org.openapitools.codegen.languages.features.BeanValidationFeatures;
import org.openapitools.codegen.languages.features.OptionalFeatures;
import org.openapitools.codegen.languages.features.UseGenericResponseFeatures;
import org.openapitools.codegen.utils.ModelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicronautCodegen
extends AbstractJavaCodegen
implements BeanValidationFeatures,
UseGenericResponseFeatures,
OptionalFeatures {
    public static final String CLIENT_ID = "clientId";
    public static final String INTROSPECTED = "introspected";
    public static final String DATETIME_RELAXED = "dateTimeRelaxed";
    public static final String JACKSON_DATABIND_NULLABLE = "jacksonDatabindNullable";
    public static final String USE_JAVAX_GENERATED = "useJavaxGenerated";
    public static final String USE_LOMBOK_GENERATED = "useLombokGenerated";
    public static final String ADDITIONAL_PROPS_COMPOSED = "supportsAdditionalPropertiesWithComposedSchema";
    public static final String USE_REFERENCED_SCHEMA_AS_DEFAULT = "useReferencedSchemaAsDefault";
    public static final String VISITABLE = "visitable";
    public static final String PAGEABLE = "pageable";
    public static final Map<String, Class<?>> CUSTOM_FORMATS = Map.of("temporal-amount", TemporalAmount.class, "period", Period.class, "duration", Duration.class, "instant", Instant.class, "local-date-time", LocalDateTime.class, "offset-date-time", OffsetDateTime.class, "zoned-date-time", ZonedDateTime.class, "local-time", LocalTime.class, "offset-time", OffsetTime.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(MicronautCodegen.class);
    private static final String UUID_PATTERN = StringUtils.repeat((String)"[a-f0-9]", (int)8) + "-" + StringUtils.repeat((String)"[a-f0-9]", (int)4) + "-" + StringUtils.repeat((String)"[a-f0-9]", (int)4) + "-" + StringUtils.repeat((String)"[a-f0-9]", (int)4) + "-" + StringUtils.repeat((String)"[a-f0-9]", (int)12);
    private boolean generateApiTests = true;
    private boolean dateTimeRelaxed = true;
    private boolean introspected = true;
    private boolean useBeanValidation = true;
    private boolean useGenericResponse = true;
    private boolean jacksonDatabindNullable = true;
    private boolean useOptional = true;
    private boolean useJavaxGenerated = true;
    private boolean useLombokGenerated = false;
    private boolean useReferencedSchemaAsDefault = false;
    private boolean visitable = true;
    private boolean pageable = false;

    public MicronautCodegen() {
        this.cliOptions.add(CliOption.newBoolean((String)"useBeanValidation", (String)"Use BeanValidation API annotations", (boolean)this.useBeanValidation));
        this.cliOptions.add(CliOption.newBoolean((String)"useGenericResponse", (String)"Use generic response", (boolean)this.useGenericResponse));
        this.cliOptions.add(CliOption.newBoolean((String)"useOptional", (String)"Use Optional<T> instead of @Nullable.", (boolean)this.useOptional));
        this.cliOptions.add(CliOption.newBoolean((String)USE_JAVAX_GENERATED, (String)"Add @javax.annotation.processing.Generated.", (boolean)this.useJavaxGenerated));
        this.cliOptions.add(CliOption.newBoolean((String)USE_LOMBOK_GENERATED, (String)"Add @lombok.Generated.", (boolean)this.useLombokGenerated));
        this.cliOptions.add(CliOption.newBoolean((String)INTROSPECTED, (String)"Add @Introspected to models", (boolean)this.introspected));
        this.cliOptions.add(CliOption.newBoolean((String)DATETIME_RELAXED, (String)"Relaxed parsing of datetimes.", (boolean)this.dateTimeRelaxed));
        this.cliOptions.add(CliOption.newBoolean((String)JACKSON_DATABIND_NULLABLE, (String)"Add wrapper from jackson-databind-nullable.", (boolean)this.jacksonDatabindNullable));
        this.cliOptions.add(CliOption.newBoolean((String)"supportAsync", (String)"Use async responses", (boolean)this.supportAsync));
        this.cliOptions.add(CliOption.newString((String)CLIENT_ID, (String)"ClientId to use."));
        this.cliOptions.add(CliOption.newBoolean((String)USE_REFERENCED_SCHEMA_AS_DEFAULT, (String)"Use the referenced schemas type as default values.", (boolean)this.useReferencedSchemaAsDefault));
        this.cliOptions.add(CliOption.newBoolean((String)VISITABLE, (String)"Generate visitor for subtypes with a discriminator.", (boolean)this.visitable));
        this.cliOptions.add(CliOption.newBoolean((String)ADDITIONAL_PROPS_COMPOSED, (String)"Support addtional properties with  composed schemas.", (boolean)this.supportsAdditionalPropertiesWithComposedSchema));
        this.cliOptions.add(CliOption.newBoolean((String)PAGEABLE, (String)"Generate provider for pageable (mironaut-data).", (boolean)this.pageable));
        this.apiDocTemplateFiles.remove("api_doc.mustache");
        this.apiTestTemplateFiles.remove("api_test.mustache");
        this.modelDocTemplateFiles.remove("model_doc.mustache");
        this.dateLibrary = "do not trigger date type selection";
        this.additionalProperties.put(INTROSPECTED, this.introspected);
        this.additionalProperties.put(DATETIME_RELAXED, this.dateTimeRelaxed);
        this.additionalProperties.put("useBeanValidation", this.useBeanValidation);
        this.additionalProperties.put("useGenericResponse", this.useGenericResponse);
        this.additionalProperties.put(JACKSON_DATABIND_NULLABLE, this.jacksonDatabindNullable);
        this.additionalProperties.put("useOptional", this.useOptional);
        this.additionalProperties.put(USE_JAVAX_GENERATED, this.useJavaxGenerated);
        this.additionalProperties.put(USE_LOMBOK_GENERATED, this.useLombokGenerated);
        this.additionalProperties.put(USE_REFERENCED_SCHEMA_AS_DEFAULT, this.useReferencedSchemaAsDefault);
        this.additionalProperties.put(VISITABLE, this.visitable);
        this.additionalProperties.put(ADDITIONAL_PROPS_COMPOSED, this.supportsAdditionalPropertiesWithComposedSchema);
        this.additionalProperties.put(PAGEABLE, this.pageable);
        this.additionalProperties.put("templateDir", "Micronaut");
        this.typeMapping.put("date", LocalDate.class.getName());
        this.typeMapping.put("DateTime", Instant.class.getName());
        this.typeMapping.put("array", List.class.getName());
        this.typeMapping.put("map", Map.class.getName());
        this.typeMapping.put("set", Set.class.getName());
        this.typeMapping.put("boolean", Boolean.class.getName());
        this.typeMapping.put("string", String.class.getName());
        this.typeMapping.put("int", Integer.class.getName());
        this.typeMapping.put("Integer", Integer.class.getName());
        this.typeMapping.put("long", Long.class.getName());
        this.typeMapping.put("float", Float.class.getName());
        this.typeMapping.put("number", Double.class.getName());
        this.typeMapping.put("BigDecimal", Double.class.getName());
        this.typeMapping.put("UUID", UUID.class.getName());
        this.typeMapping.put("URI", URI.class.getName());
        this.typeMapping.put("file", "byte[]");
        this.typeMapping.put("AnyType", Object.class.getName());
        this.typeMapping.put("fileUpload", "io.micronaut.http.multipart.CompletedFileUpload");
        this.typeMapping.put("asyncCompletable", "io.reactivex.Completable");
        this.typeMapping.put("asyncSingle", "io.reactivex.Single");
        this.typeMapping.put("asyncMaybe", "io.reactivex.Maybe");
        this.typeMapping.put("asyncFlowable", "io.reactivex.Flowable");
        this.typeMapping.put("asyncFileUpload", "io.micronaut.http.multipart.StreamingFileUpload");
        this.typeMapping.put("Nullable", Nullable.class.getName());
        this.typeMapping.put("Nonnull", Nonnull.class.getName());
        this.typeMapping.put("Inject", Inject.class.getName());
        this.typeMapping.put("Singleton", Singleton.class.getName());
        this.instantiationTypes.put("array", ArrayList.class.getName());
        this.instantiationTypes.put("map", HashMap.class.getName());
        this.instantiationTypes.put("set", LinkedHashSet.class.getName());
        this.importMapping.clear();
    }

    public void postProcess() {
    }

    public String getName() {
        return "micronaut";
    }

    public void processOpts() {
        this.apiPackage = (String)this.additionalProperties.computeIfAbsent("apiPackage", k -> "changeMe");
        this.modelPackage = (String)this.additionalProperties.computeIfAbsent("modelPackage", k -> this.apiPackage);
        this.invokerPackage = (String)this.additionalProperties.computeIfAbsent("invokerPackage", k -> this.apiPackage);
        super.processOpts();
        if (this.additionalProperties.containsKey(INTROSPECTED)) {
            this.introspected = this.convertPropertyToBooleanAndWriteBack(INTROSPECTED);
        }
        if (this.additionalProperties.containsKey(DATETIME_RELAXED)) {
            this.dateTimeRelaxed = this.convertPropertyToBooleanAndWriteBack(DATETIME_RELAXED);
        }
        if (this.additionalProperties.containsKey("useBeanValidation")) {
            this.useBeanValidation = this.convertPropertyToBooleanAndWriteBack("useBeanValidation");
        }
        if (this.additionalProperties.containsKey("useGenericResponse")) {
            this.useGenericResponse = this.convertPropertyToBooleanAndWriteBack("useGenericResponse");
        }
        if (this.additionalProperties.containsKey(JACKSON_DATABIND_NULLABLE)) {
            this.jacksonDatabindNullable = this.convertPropertyToBooleanAndWriteBack(JACKSON_DATABIND_NULLABLE);
        }
        if (this.additionalProperties.containsKey("useOptional")) {
            this.useOptional = this.convertPropertyToBooleanAndWriteBack("useOptional");
        }
        if (this.additionalProperties.containsKey(USE_JAVAX_GENERATED)) {
            this.useJavaxGenerated = this.convertPropertyToBooleanAndWriteBack(USE_JAVAX_GENERATED);
        }
        if (this.additionalProperties.containsKey(USE_LOMBOK_GENERATED)) {
            this.useLombokGenerated = this.convertPropertyToBooleanAndWriteBack(USE_LOMBOK_GENERATED);
        }
        if (this.additionalProperties.containsKey("generateApiTests")) {
            this.generateApiTests = this.convertPropertyToBooleanAndWriteBack("generateApiTests");
        }
        if (this.additionalProperties.containsKey(USE_REFERENCED_SCHEMA_AS_DEFAULT)) {
            this.useReferencedSchemaAsDefault = this.convertPropertyToBooleanAndWriteBack(USE_REFERENCED_SCHEMA_AS_DEFAULT);
        }
        if (this.additionalProperties.containsKey(VISITABLE)) {
            this.visitable = this.convertPropertyToBooleanAndWriteBack(VISITABLE);
        }
        if (this.additionalProperties.containsKey(PAGEABLE)) {
            this.pageable = this.convertPropertyToBooleanAndWriteBack(PAGEABLE);
        }
        if (this.additionalProperties.containsKey(ADDITIONAL_PROPS_COMPOSED)) {
            this.supportsAdditionalPropertiesWithComposedSchema = this.convertPropertyToBooleanAndWriteBack(ADDITIONAL_PROPS_COMPOSED);
        }
        this.projectFolder = "generated-sources";
        this.projectTestFolder = "generated-test-sources";
        this.sourceFolder = this.projectFolder + File.separator + "openapi";
        this.testFolder = this.projectTestFolder + File.separator + "openapi";
        if (this.additionalProperties.containsKey(CLIENT_ID)) {
            this.apiTemplateFiles.put("api_client.mustache", "Client.java");
        }
        if (this.generateApiTests) {
            this.apiTestTemplateFiles.put("test.mustache", "Spec.java");
            this.apiTestTemplateFiles.put("test_client.mustache", "Client.java");
            this.addSupportingFile(this.testFolder, this.invokerPackage, "HttpResponseAssertions");
        }
        if (this.dateTimeRelaxed && !this.openAPI.getPaths().isEmpty()) {
            this.addSupportingFile(this.sourceFolder, this.invokerPackage, "TimeTypeConverterRegistrar");
        }
        if (this.pageable) {
            this.addSupportingFile(this.sourceFolder, this.invokerPackage, "PageableProvider");
        }
        this.additionalProperties.put("type.Nullable", this.typeMapping.get("Nullable"));
        this.additionalProperties.put("type.Nonnull", this.typeMapping.get("Nonnull"));
        this.additionalProperties.put("type.Inject", this.typeMapping.get("Inject"));
        this.additionalProperties.put("type.Singleton", this.typeMapping.get("Singleton"));
    }

    public CodegenOperation fromOperation(String path, String httpMethod, Operation source, List<Server> servers) {
        List arrayParams;
        boolean useGeneric;
        CodegenOperation operation = super.fromOperation(path, httpMethod, source, servers);
        Map extensions = operation.vendorExtensions;
        Optional<CodegenResponse> wildcardResponse = operation.responses.stream().filter(CodegenResponse::isWildcard).findAny();
        if (wildcardResponse.isPresent() && operation.responses.size() == 1) {
            String message = "Operation " + operation.nickname + " has no documented response code, only default.";
            LOGGER.warn(message);
            if (this.isStrictSpecBehavior()) {
                throw new SpecValidationException(message);
            }
            wildcardResponse.ifPresent(response -> {
                response.code = response.dataType == null ? "204" : "200";
            });
        }
        CodegenResponse response2 = operation.responses.stream().filter(r -> !r.isWildcard()).findAny().orElseGet(wildcardResponse::get);
        List responses = operation.responses.stream().filter(r -> {
            if (r.isRange()) {
                throw new SpecValidationException("Range responses are not supported: " + r.code);
            }
            int code = Integer.parseInt(r.code);
            return code >= 200 && code < 400;
        }).collect(Collectors.toList());
        boolean bl = useGeneric = responses.size() > 1;
        if (responses.size() > 1) {
            boolean hasMultipleBodyTypes;
            boolean bl2 = hasMultipleBodyTypes = responses.stream().map(r -> r.dataType).distinct().count() > 1L;
            if (hasMultipleBodyTypes) {
                operation.returnType = null;
            }
        }
        if (operation.produces != null && operation.produces.size() > 1) {
            boolean hasMultipleBodyTypes;
            ApiResponse specResponse = (ApiResponse)response2.vendorExtensions.get(ApiResponse.class.getName());
            boolean bl3 = hasMultipleBodyTypes = specResponse.getContent().values().stream().distinct().count() > 1L;
            if (hasMultipleBodyTypes) {
                operation.returnType = null;
                useGeneric = true;
            }
        }
        Optional.ofNullable(operation.produces).ifPresent(p -> p.removeIf(m -> "*/*".equals(m.get("mediaType"))));
        Optional.ofNullable(operation.consumes).ifPresent(c -> c.removeIf(m -> "*/*".equals(m.get("mediaType"))));
        extensions.put("httpMethod", httpMethod.toUpperCase().charAt(0) + httpMethod.substring(1).toLowerCase());
        extensions.put("generic", this.useGenericResponse || response2.hasHeaders || useGeneric);
        extensions.put("status", HttpStatus.valueOf((int)Integer.parseInt(response2.code)).name());
        operation.responses.forEach(r -> extensions.put("has" + r.code, true));
        if (CollectionUtils.isNotEmpty((Collection)operation.pathParams)) {
            for (CodegenParameter param : operation.pathParams) {
                String name = param.paramName;
                if (param.isUuid) {
                    operation.path = operation.path.replace("{" + name + "}", "{" + name + ":" + UUID_PATTERN + "}");
                }
                if (param.isString && param.maxLength != null) {
                    operation.path = operation.path.replace("{" + name + "}", "{" + name + ":" + param.maxLength + "}");
                }
                if (!param.isInteger) continue;
                operation.path = operation.path.replace("{" + name + "}", "{" + name + ":[0-9]+}");
            }
        }
        if (!(arrayParams = operation.queryParams.stream().filter(p -> p.isArray).collect(Collectors.toList())).isEmpty()) {
            extensions.put("path", operation.path + "?" + arrayParams.stream().map(p -> "{&" + p.baseName + "*}").collect(Collectors.joining()));
        } else {
            extensions.put("path", operation.path);
        }
        boolean hasSecurityJwt = operation.vendorExtensions.getOrDefault("has401", false);
        if (this.generateApiTests && hasSecurityJwt) {
            this.addSupportingFile(this.testFolder, this.invokerPackage, "JwtProvider");
            this.addSupportingFile(this.testFolder, this.invokerPackage, "JwtBuilder");
        }
        if (this.supportAsync) {
            boolean isVoid = operation.returnType == null;
            boolean isStream = Optional.ofNullable((ApiResponse)source.getResponses().get((Object)"200")).map(ApiResponse::getContent).filter(content -> content.containsKey((Object)"application/x-json-stream")).isPresent();
            extensions.put("asyncContainer", this.typeMapping.get("asyncSingle"));
            extensions.put("asyncStream", isStream);
            if (!this.useGenericResponse) {
                if (isVoid) {
                    extensions.put("asyncContainer", this.typeMapping.get("asyncCompletable"));
                } else if (operation.vendorExtensions.getOrDefault("has404", false).booleanValue()) {
                    extensions.put("asyncContainer", this.typeMapping.get("asyncMaybe"));
                }
            }
            if (isStream) {
                extensions.put("asyncContainer", this.typeMapping.get("asyncFlowable"));
            }
        }
        return operation;
    }

    public CodegenResponse fromResponse(String responseCode, ApiResponse response) {
        CodegenResponse codegenResponse = super.fromResponse(responseCode, response);
        codegenResponse.vendorExtensions.put(ApiResponse.class.getName(), response);
        return codegenResponse;
    }

    public String getSchemaType(Schema schema) {
        ComposedSchema cs;
        String format = schema.getFormat();
        if (schema instanceof StringSchema && format != null && CUSTOM_FORMATS.containsKey(format)) {
            String type = CUSTOM_FORMATS.get(format).getName();
            LOGGER.warn("Use custom format {} with type {}.", (Object)format, (Object)type);
            return type;
        }
        if (schema instanceof ComposedSchema && CollectionUtils.isNotEmpty((Collection)(cs = (ComposedSchema)schema).getOneOf())) {
            return Object.class.getName();
        }
        return super.getSchemaType(schema);
    }

    public String toDefaultValue(Schema schema) {
        if (this.useReferencedSchemaAsDefault && schema.get$ref() != null) {
            return "new " + this.getSchemaType(schema) + "()";
        }
        if (ModelUtils.isSet((Schema)schema)) {
            return "new " + (String)this.instantiationTypes.get("set") + "<>()";
        }
        if (ModelUtils.isArraySchema((Schema)schema)) {
            return "new " + (String)this.instantiationTypes.get("array") + "<>()";
        }
        if (ModelUtils.isMapSchema((Schema)schema)) {
            return "new " + (String)this.instantiationTypes.get("map") + "<>()";
        }
        return super.toDefaultValue(schema);
    }

    public Map<String, Object> updateAllModels(Map<String, Object> objs) {
        Map superObjs = super.updateAllModels(objs);
        Map allModels = this.getAllModels(objs);
        for (CodegenModel model : allModels.values()) {
            CodegenDiscriminator discriminator;
            if (this.supportsAdditionalPropertiesWithComposedSchema && model.getAdditionalProperties() != null) {
                model.getVendorExtensions().put("additionalPropertiesMap", String.format("java.util.Map<java.lang.String, %s>", model.getAdditionalProperties().getDataType()));
            }
            if ((discriminator = model.discriminator) == null) continue;
            model.vars.stream().filter(property -> property.getName().equals(discriminator.getPropertyName())).findAny().ifPresent(property -> {
                discriminator.setPropertyType(property.getDataType());
                model.vars.remove(property);
            });
            block12: for (CodegenDiscriminator.MappedModel mappedModel : discriminator.getMappedModels()) {
                CodegenModel subModel = (CodegenModel)allModels.get(mappedModel.getModelName());
                if (subModel == null) {
                    LOGGER.warn("{} - model in discriminator {} with name {} not found", new Object[]{model.name, discriminator.getPropertyName(), mappedModel.getModelName()});
                    continue;
                }
                if (subModel.parentModel == null) {
                    subModel.parentModel = model;
                    subModel.parent = model.getClassname();
                    LOGGER.warn("{} added missing sub model {}", (Object)model.name, (Object)subModel.name);
                }
                subModel.vars.removeIf(property -> property.getName().equals(discriminator.getPropertyName()));
                Map extensions = subModel.getVendorExtensions();
                extensions.put("discriminatorPropertyGetter", discriminator.getPropertyGetter());
                extensions.put("discriminatorPropertyType", discriminator.getPropertyType());
                switch (discriminator.getPropertyType()) {
                    case "java.lang.String": {
                        extensions.put("discriminatorPropertyValue", "\"" + mappedModel.getMappingName() + "\"");
                        continue block12;
                    }
                    case "java.lang.Long": 
                    case "java.lang.Integer": 
                    case "java.lang.Double": 
                    case "java.lang.Float": {
                        extensions.put("discriminatorPropertyValue", mappedModel.getMappingName());
                        continue block12;
                    }
                }
                extensions.put("discriminatorPropertyValue", discriminator.getPropertyType() + "." + this.toEnumVarName(mappedModel.getMappingName(), ""));
            }
        }
        return superObjs;
    }

    public void postProcessParameter(CodegenParameter parameter) {
        if (parameter.isFormParam && parameter.isFile) {
            parameter.dataType = (String)this.typeMapping.get(this.supportAsync ? "asyncFileUpload" : "fileUpload");
        }
    }

    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        super.postProcessModelProperty(model, property);
        if (property.isEnum) {
            if (property.defaultValue != null) {
                property.defaultValue = this.toEnumName(property) + "." + this.toEnumVarName(property.defaultValue, property.dataType);
            }
            if (property.isMap && property.items != null) {
                property.dataType = property.items.dataType;
                property.datatypeWithEnum = (String)this.typeMapping.get("map") + "<" + (String)this.typeMapping.get("string") + ", " + this.toEnumName(property) + ">";
                property.items.datatypeWithEnum = this.toEnumName(property);
                property.defaultValue = "new " + (String)this.instantiationTypes.get("map") + "<>()";
            }
            if (property.isArray && property.items != null) {
                property.dataType = property.items.dataType;
                property.datatypeWithEnum = (String)this.typeMapping.get("array") + "<" + this.toEnumName(property) + ">";
                property.defaultValue = "new " + (String)this.instantiationTypes.get("array") + "<>()";
            }
        }
        if ("byte[]".equals(property.dataType)) {
            property.isByteArray = true;
        }
    }

    public String toEnumName(CodegenProperty property) {
        return property.nameInCamelCase;
    }

    public String toEnumVarName(String value, String datatype) {
        return super.toEnumVarName(value, datatype.replace("java.lang.", ""));
    }

    public String toEnumValue(String value, String datatype) {
        if (List.of("int", Integer.class.getSimpleName(), Integer.class.getName()).contains(datatype)) {
            return value;
        }
        if (List.of("long", Long.class.getSimpleName(), Long.class.getName()).contains(datatype)) {
            return value + "L";
        }
        if (List.of("float", Float.class.getSimpleName(), Float.class.getName()).contains(datatype)) {
            return value + "F";
        }
        if (List.of("double", Double.class.getSimpleName(), Double.class.getName()).contains(datatype)) {
            return value + "D";
        }
        return super.toEnumValue(value, datatype);
    }

    public void setUseBeanValidation(boolean useBeanValidation) {
        this.useBeanValidation = useBeanValidation;
    }

    public void setUseGenericResponse(boolean useGenericResponse) {
        this.useGenericResponse = useGenericResponse;
    }

    public void setUseOptional(boolean useOptional) {
        this.useOptional = useOptional;
    }

    void addSupportingFile(String folder, String packageString, String file) {
        String destinationFilename;
        String templateFile = "support/" + file + ".mustache";
        SupportingFile supportingFile = new SupportingFile(templateFile, destinationFilename = folder + "/" + packageString.replace(".", "/") + "/" + file + ".java");
        if (!this.supportingFiles.contains(supportingFile)) {
            this.supportingFiles.add(supportingFile);
        }
    }
}

