/*
 * Decompiled with CFR 0.152.
 */
package io.konig.content.client;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.auth.Credentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import io.konig.content.Asset;
import io.konig.content.AssetBundle;
import io.konig.content.AssetBundleKey;
import io.konig.content.AssetMetadata;
import io.konig.content.CheckInBundleResponse;
import io.konig.content.ContentAccessException;
import io.konig.content.ContentSystemUtil;
import io.konig.content.EtagFactory;
import io.konig.content.client.ContentSystemClient;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentPublisher {
    private static final Logger logger = LoggerFactory.getLogger(ContentPublisher.class);
    private boolean compress = true;
    private File credentialsFile;

    public void publish(File baseDir, String contentURL, String bundleName, String bundleVersion) throws IOException, ContentAccessException {
        ArrayList metaList = new ArrayList();
        AssetBundle bundle = new AssetBundle(bundleName, bundleVersion);
        AssetBundleKey bundleKey = bundle.getKey();
        bundle.setMetadataList(metaList);
        this.addAssets(bundle, baseDir, "/");
        logger.info("Publishing to: {}", (Object)bundleKey.url(contentURL));
        ContentSystemClient client = new ContentSystemClient(contentURL);
        CheckInBundleResponse response = client.checkInBundle(bundle);
        Collections.sort(response.getMissingAssets());
        List requiredAssets = response.getMissingAssets();
        if (!requiredAssets.isEmpty()) {
            String editAddress = response.getEditServiceAddress();
            if (editAddress == null) {
                throw new ContentAccessException("Link header with 'rel=edit' not found in response from Content System client");
            }
            if (this.compress) {
                Throwable throwable;
                File zipFile = this.zipFile(baseDir, bundleKey);
                try (FileOutputStream fos = new FileOutputStream(zipFile);){
                    throwable = null;
                    try (ZipOutputStream zos = new ZipOutputStream(fos);){
                        for (String path : requiredAssets) {
                            String filePath = ContentSystemUtil.trimSlashes((String)path);
                            this.addZipEntry(zos, baseDir, filePath);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                Bucket bucket = this.getBucket(editAddress);
                String objectId = bundleKey.getName() + "/" + bundleKey.getVersion();
                throwable = null;
                try (FileInputStream contentStream = new FileInputStream(zipFile);){
                    bucket.create(objectId, (InputStream)contentStream, "application/zip", new Bucket.BlobWriteOption[0]);
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                String baseUrl = this.baseUrl(contentURL);
                String enqueueURL = baseUrl + "/tasks/content-bundle-enqueue";
                byte[] payload = this.bundleEnqueueRequest(bucket.getName(), objectId);
                ByteArrayEntity entity = new ByteArrayEntity(payload);
                HttpPost post = new HttpPost(enqueueURL);
                entity.setContentType("application/json");
                post.setEntity((HttpEntity)entity);
                CloseableHttpClient httpClient = HttpClients.createDefault();
                CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)post);
                logger.info(httpResponse.getStatusLine().toString());
            } else {
                for (String path : requiredAssets) {
                    String filePath = path.substring(1);
                    File assetFile = new File(baseDir, filePath);
                    Asset asset = this.loadAsset(bundleKey, path, assetFile);
                    client.saveAsset(asset);
                    logger.info(path);
                }
            }
        } else {
            logger.info("All assets are up-to-date");
        }
    }

    private byte[] bundleEnqueueRequest(String bucketId, String objectId) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JsonFactory factory = new JsonFactory();
        JsonGenerator json = factory.createGenerator((OutputStream)out, JsonEncoding.UTF8);
        json.writeStartObject();
        json.writeStringField("bucketId", bucketId);
        json.writeStringField("objectId", objectId);
        json.writeEndObject();
        json.close();
        return out.toByteArray();
    }

    private String baseUrl(String contentURL) {
        int slash = contentURL.lastIndexOf(47, contentURL.length() - 2);
        return contentURL.substring(0, slash);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Bucket getBucket(String editAddress) throws ContentAccessException {
        File credentialsFile = this.getCredentialsFile();
        if (credentialsFile == null) {
            throw new ContentAccessException("Google service account credentials not found.  Please set the credentialsFile property or the GOOGLE_APPLICATION_CREDENTIALS environment variable");
        }
        if (!credentialsFile.exists()) {
            throw new ContentAccessException("Credentials file does not exist: " + credentialsFile.getAbsolutePath());
        }
        try (FileInputStream credentialsStream = new FileInputStream(credentialsFile);){
            Storage storage = (Storage)((StorageOptions.Builder)StorageOptions.newBuilder().setCredentials((Credentials)ServiceAccountCredentials.fromStream((InputStream)credentialsStream))).build().getService();
            int slash = editAddress.lastIndexOf(47);
            String bucketName = editAddress.substring(slash + 1);
            Bucket bucket = storage.get(bucketName, new Storage.BucketGetOption[0]);
            return bucket;
        }
        catch (IOException e) {
            throw new ContentAccessException((Throwable)e);
        }
    }

    private File getCredentialsFile() {
        String value;
        File result = this.credentialsFile;
        if (result == null && (value = System.getenv("GOOGLE_APPLICATION_CREDENTIALS")) != null) {
            result = new File(value);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addZipEntry(ZipOutputStream zos, File baseDir, String filePath) throws IOException {
        logger.info(filePath);
        File file = new File(baseDir, filePath);
        FileInputStream fis = new FileInputStream(file);
        try {
            int length;
            ZipEntry entry = new ZipEntry(filePath);
            zos.putNextEntry(entry);
            byte[] bytes = new byte[1024];
            while ((length = fis.read(bytes)) >= 0) {
                zos.write(bytes, 0, length);
            }
            zos.closeEntry();
        }
        finally {
            this.close(fis, file.getAbsolutePath());
        }
    }

    private void close(Closeable stream, String name) {
        try {
            stream.close();
        }
        catch (IOException e) {
            logger.warn("Failed to close stream: {}", (Object)name);
        }
    }

    private File zipFile(File baseDir, AssetBundleKey bundleKey) {
        StringBuilder builder = new StringBuilder();
        builder.append(bundleKey.getName());
        builder.append('-');
        builder.append(bundleKey.getVersion());
        builder.append(".zip");
        File parent = baseDir.getParentFile();
        return new File(parent, builder.toString());
    }

    private Asset loadAsset(AssetBundleKey bundleKey, String assetPath, File assetFile) throws IOException {
        Path path = assetFile.toPath();
        String contentType = Files.probeContentType(path);
        byte[] body = Files.readAllBytes(path);
        String etag = EtagFactory.createEtag((byte[])body);
        AssetMetadata meta = new AssetMetadata();
        meta.setBundleKey(bundleKey);
        meta.setPath(assetPath);
        meta.setContentType(contentType);
        meta.setEtag(etag);
        meta.setPath(assetPath);
        return new Asset(meta, body);
    }

    private void addAssets(AssetBundle bundle, File dir, String parentPath) throws IOException {
        if (dir.isDirectory()) {
            File[] array;
            List metaList = bundle.getMetadataList();
            for (File file : array = dir.listFiles()) {
                StringBuilder pathBuilder = new StringBuilder();
                pathBuilder.append(parentPath);
                pathBuilder.append(file.getName());
                if (file.isDirectory()) {
                    pathBuilder.append('/');
                    this.addAssets(bundle, file, pathBuilder.toString());
                    continue;
                }
                Path path = file.toPath();
                byte[] data = Files.readAllBytes(path);
                String etag = EtagFactory.createEtag((byte[])data);
                AssetMetadata meta = new AssetMetadata();
                meta.setBundleKey(bundle.getKey());
                meta.setEtag(etag);
                meta.setPath(pathBuilder.toString());
                metaList.add(meta);
            }
        }
    }
}

