/*
 * Decompiled with CFR 0.152.
 */
package io.konig.content.client;

import io.konig.content.Asset;
import io.konig.content.AssetBundle;
import io.konig.content.AssetBundleKey;
import io.konig.content.AssetBundleWriter;
import io.konig.content.AssetMetadata;
import io.konig.content.CheckInBundleResponse;
import io.konig.content.ContentAccessException;
import io.konig.content.ContentSystem;
import io.konig.content.ZipArchive;
import io.konig.content.client.LinkUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentSystemClient
implements ContentSystem {
    private static Logger logger = LoggerFactory.getLogger(ContentSystemClient.class);
    private String baseURL;

    public ContentSystemClient(String baseURL) {
        this.baseURL = baseURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CheckInBundleResponse checkInBundle(AssetBundle bundle) throws ContentAccessException {
        CheckInBundleResponse result = new CheckInBundleResponse();
        AssetBundleWriter bundleWriter = new AssetBundleWriter();
        StringWriter buffer = new StringWriter();
        try (PrintWriter out = new PrintWriter(buffer);){
            bundleWriter.writeBundle(bundle, out);
            String text = buffer.toString();
            StringEntity entity = new StringEntity(text);
            String bundleURL = bundle.getKey().url(this.baseURL);
            HttpPost post = new HttpPost(bundleURL);
            post.setEntity((HttpEntity)entity);
            CloseableHttpClient client = HttpClients.createDefault();
            try (CloseableHttpResponse response = client.execute((HttpUriRequest)post);){
                int status = response.getStatusLine().getStatusCode();
                if (status != 200 && status != 201) {
                    StatusLine statusLine = response.getStatusLine();
                    String msg = MessageFormat.format("Check-in failed at <{0}> with status {1} {2}", bundleURL, statusLine.getStatusCode(), statusLine.getReasonPhrase());
                    throw new ContentAccessException(msg);
                }
                result.setEditServiceAddress(this.editServiceAddress(response));
                InputStream input = response.getEntity().getContent();
                InputStreamReader reader = new InputStreamReader(input);
                BufferedReader lineReader = new BufferedReader(reader);
                ArrayList<String> pathList = new ArrayList<String>();
                String line = null;
                while ((line = lineReader.readLine()) != null) {
                    if ((line = line.trim()).length() <= 0) continue;
                    pathList.add(line);
                }
                result.setMissingAssets(pathList);
            }
        }
        return result;
    }

    private String editServiceAddress(CloseableHttpResponse response) {
        return LinkUtil.getLink(response.getHeaders("Link"), "edit");
    }

    public int saveMetadata(AssetMetadata metadata) throws ContentAccessException {
        throw new ContentAccessException("saveMetadata method not supported by this client");
    }

    public AssetMetadata getMetadata(String path) throws ContentAccessException {
        throw new ContentAccessException("getMetadata method not supported by this client");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int saveAsset(Asset asset) throws ContentAccessException {
        int status = 0;
        AssetMetadata meta = asset.getMetadata();
        CloseableHttpClient client = HttpClients.createDefault();
        String assetURL = meta.getBundleKey().assetURL(this.baseURL, meta);
        if (assetURL.indexOf(123) >= 0) {
            logger.warn("Skipping invalid URL: {}", (Object)assetURL);
            return 400;
        }
        HttpPost post = new HttpPost(assetURL);
        if (meta.getContentType() != null) {
            post.setHeader("Content-Type", meta.getContentType());
        }
        post.setEntity((HttpEntity)new ByteArrayEntity(asset.getBody()));
        try (CloseableHttpResponse response = client.execute((HttpUriRequest)post);){
            status = response.getStatusLine().getStatusCode();
        }
        catch (IOException e) {
            throw new ContentAccessException((Throwable)e);
        }
        return status;
    }

    public Asset getAsset(String path) throws ContentAccessException {
        throw new ContentAccessException("getAsset method is not supported by this client");
    }

    public int saveBundle(AssetBundleKey bundleKey, ZipArchive archive) throws ContentAccessException {
        throw new ContentAccessException("Not implemented");
    }
}

