package io.konig.cadl;

import java.util.Collection;

/*
 * #%L
 * Konig Core
 * %%
 * Copyright (C) 2015 - 2019 Gregory McFall
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */


import java.util.LinkedHashMap;
import java.util.Map;

import org.openrdf.model.URI;

public class CubeManager {
	private Map<URI,Cube> cubes = new LinkedHashMap<>();
	
	public void add(Cube cube) {
		cubes.put(cube.getId(), cube);
	}
	
	public Cube findById(URI cubeId) {
		return cubes.get(cubeId);
	}
	
	public Cube produceCube(URI cubeId) {
		Cube cube = findById(cubeId);
		if (cube == null) {
			cube = new Cube();
			cube.setId(cubeId);
			add(cube);
		}
		return cube;
	}

	public Collection<Cube> listCubes() {
		return cubes.values();
	}

}
