package io.konig.core.showl;

/*
 * #%L
 * Konig Core
 * %%
 * Copyright (C) 2015 - 2019 Gregory McFall
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */


import org.openrdf.model.URI;

import io.konig.core.Graph;
import io.konig.core.vocab.Konig;
import io.konig.datasource.DataSource;
import io.konig.shacl.Shape;

public class ConsumesDataFromFilter implements ShowlMappingFilter {
	
	private Graph graph;
	

	public ConsumesDataFromFilter(Graph graph) {
		this.graph = graph;
	}


	@Override
	public boolean allowMapping(ShowlNodeShape source, ShowlNodeShape target) {
		
		Shape sourceShape = source.getShape();
		Shape targetShape = target.getShape();
		if (sourceShape!=null && targetShape!=null) {
			for (DataSource targetChannel : targetShape.getShapeDataSource()) {
				for (URI targetSystem : targetChannel.getIsPartOf()) {
					if (graph.getVertex(targetSystem) != null) {
						for (DataSource sourceChannel : sourceShape.getShapeDataSource()) {
							for (URI sourceSystem : sourceChannel.getIsPartOf()) {
								if (graph.contains(targetSystem, Konig.consumesDataFrom, sourceSystem)) {
									return true;
								}
							}
						}
					}
				}
			}
		}
		return false;
	}

}
